/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.bson4jackson;

import de.undercouch.bson4jackson.BsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

class MongoBsonGenerator
extends BsonGenerator {
    public MongoBsonGenerator(int jsonFeatures, int bsonFeatures, OutputStream out) {
        super(jsonFeatures, bsonFeatures, out);
    }

    public void writeNativeObjectId(ObjectId objectId) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write datetime");
        this._buffer.putByte(this._typeMarker, (byte)7);
        this._buffer.putBytes(objectId.toByteArray());
        this.flushBuffer();
    }

    public void writeBSONTimestamp(BSONTimestamp timestamp) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write timestamp");
        this._buffer.putByte(this._typeMarker, (byte)17);
        this._buffer.putInt(timestamp.getInc());
        this._buffer.putInt(timestamp.getTime());
        this.flushBuffer();
    }

    public void writeMinKey(MinKey key) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write int");
        this._buffer.putByte(this._typeMarker, (byte)-1);
        this.flushBuffer();
    }

    public void writeMaxKey(MaxKey key) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write boolean");
        this._buffer.putByte(this._typeMarker, (byte)127);
        this.flushBuffer();
    }

    public void writeBinary(Binary binary) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write binary");
        byte[] bytes = binary.getData();
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(bytes.length);
        this._buffer.putByte(binary.getType());
        this._buffer.putBytes(binary.getData());
        this.flushBuffer();
    }
}

