/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.jongo.marshall.jackson.configuration.AbstractMappingBuilder;
import org.jongo.marshall.jackson.configuration.ReaderCallback;
import org.jongo.marshall.jackson.configuration.WriterCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapping {
    private ObjectMapper mapper;
    private ReaderCallback readerCallback;
    private WriterCallback writerCallback;

    public Mapping(ObjectMapper mapper, ReaderCallback readerCallback, WriterCallback writerCallback) {
        this.mapper = mapper;
        this.readerCallback = readerCallback;
        this.writerCallback = writerCallback;
    }

    public ObjectReader getReader(Class<?> clazz) {
        return this.readerCallback.getReader(this.mapper, clazz);
    }

    public ObjectWriter getWriter(Object pojo) {
        return this.writerCallback.getWriter(this.mapper, pojo);
    }

    public static Mapping defaultMapping() {
        return new Builder().build();
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AbstractMappingBuilder<Builder> {
        public Builder() {
        }

        public Builder(ObjectMapper mapper) {
            super(mapper);
        }

        @Override
        protected Builder getBuilderInstance() {
            return this;
        }

        public Mapping build() {
            return this.createMapping();
        }
    }
}

