/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.oid;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private boolean fieldIsObjectId = false;

    public ObjectIdDeserializer() {
        this(false);
    }

    public ObjectIdDeserializer(boolean fieldIsObjectId) {
        this.fieldIsObjectId = fieldIsObjectId;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        TreeNode treeNode = jp.readValueAsTree();
        JsonNode oid = ((JsonNode)treeNode).get("$oid");
        if (this.fieldIsObjectId) {
            if (oid != null) {
                return new ObjectId(oid.asText());
            }
            return new ObjectId(((JsonNode)treeNode).asText());
        }
        if (oid != null) {
            return oid.asText();
        }
        return ((JsonNode)treeNode).asText();
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        return new ObjectIdDeserializer(ObjectId.class.isAssignableFrom(property.getType().getRawClass()));
    }
}

