/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.oid;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    boolean fieldIsObjectId = false;

    public ObjectIdSerializer() {
        this(false);
    }

    public ObjectIdSerializer(boolean serializeAsObjectId) {
        this.fieldIsObjectId = serializeAsObjectId;
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value == null) {
            jgen.writeNull();
        } else if (this.fieldIsObjectId) {
            jgen.writeObject(value);
        } else {
            jgen.writeObject((Object)new ObjectId(value.toString()));
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        return new ObjectIdSerializer(ObjectId.class.isAssignableFrom(property.getType().getRawClass()));
    }
}

