/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.query;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.BSON;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.jongo.bson.Bson;
import org.jongo.bson.BsonDocument;
import org.jongo.marshall.Marshaller;
import org.jongo.marshall.MarshallingException;
import org.jongo.query.Query;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BsonQueryFactory
implements QueryFactory {
    private static final String DEFAULT_TOKEN = "#";
    private static final String MARSHALL_OPERATOR = "$marshall";
    private final String token;
    private final Marshaller marshaller;

    public BsonQueryFactory(Marshaller marshaller) {
        this(marshaller, DEFAULT_TOKEN);
    }

    public BsonQueryFactory(Marshaller marshaller, String token) {
        this.token = token;
        this.marshaller = marshaller;
    }

    @Override
    public Query createQuery(final String query, Object ... parameters) {
        DBObject dbo;
        int pos;
        if (query == null) {
            return new BsonQuery((DBObject)JSON.parse((String)query));
        }
        if (parameters == null) {
            parameters = new Object[]{null};
        }
        StringBuilder sb = new StringBuilder();
        int paramIncrement = 0;
        int paramPos = 0;
        int start = 0;
        while ((pos = query.indexOf(this.token, start)) != -1) {
            if (paramPos >= parameters.length) {
                throw new IllegalArgumentException("Not enough parameters passed to query: " + query);
            }
            sb.append(query, start, pos);
            if (this.isValueToken(query, pos)) {
                sb.append("{\"").append(MARSHALL_OPERATOR).append("\":").append(paramIncrement).append("}");
                paramIncrement = 0;
            } else {
                sb.append(parameters[paramPos]);
                ++paramIncrement;
            }
            ++paramPos;
            start = pos + this.token.length();
        }
        sb.append(query, start, query.length());
        if (paramPos < parameters.length) {
            throw new IllegalArgumentException("Too many parameters passed to query: " + query);
        }
        final Object[] params = parameters;
        try {
            dbo = (DBObject)JSON.parse((String)sb.toString(), (BSONCallback)new JSONCallback(){
                int paramPos = 0;

                public Object objectDone() {
                    BSONObject dbo;
                    Object marshallValue;
                    String name = this.curName();
                    Object o = super.objectDone();
                    if (o instanceof BSONObject && !(o instanceof List) && (marshallValue = (dbo = (BSONObject)o).get(BsonQueryFactory.MARSHALL_OPERATOR)) != null) {
                        this.paramPos += ((Number)marshallValue).intValue();
                        if (this.paramPos >= params.length) {
                            throw new IllegalArgumentException("Not enough parameters passed to query: " + query);
                        }
                        o = BsonQueryFactory.this.marshallParameter(params[this.paramPos++]);
                        if (!this.isStackEmpty()) {
                            this._put(name, o);
                        } else {
                            o = !BSON.hasDecodeHooks() ? o : BSON.applyDecodingHooks((Object)o);
                            this.setRoot(o);
                        }
                    }
                    if (this.isStackEmpty()) {
                        // empty if block
                    }
                    return o;
                }
            });
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse query: " + query, e);
        }
        return new BsonQuery(dbo);
    }

    private boolean isValueToken(String query, int tokenIndex) {
        for (int pos = tokenIndex; pos >= 0; --pos) {
            char c = query.charAt(pos);
            if (c == ':') {
                return true;
            }
            if (c == '{' || c == '.') {
                return false;
            }
            if (c != ',') continue;
            return !this.isPropertyName(query, pos - 1);
        }
        return true;
    }

    private boolean isPropertyName(String query, int tokenIndex) {
        for (int pos = tokenIndex; pos >= 0; --pos) {
            char c = query.charAt(pos);
            if (c == '[') {
                return false;
            }
            if (c != '{') continue;
            return true;
        }
        return false;
    }

    private Object marshallParameter(Object parameter) {
        try {
            if (parameter == null || Bson.isPrimitive(parameter)) {
                return parameter;
            }
            if (parameter instanceof Collection) {
                return this.marshallCollection((Collection)parameter);
            }
            if (parameter instanceof Object[]) {
                return this.marshallArray((Object[])parameter);
            }
            return this.marshallDocument(parameter);
        }
        catch (Exception e) {
            String message = String.format("Unable to marshall parameter: %s", parameter);
            throw new MarshallingException(message, e);
        }
    }

    private DBObject marshallArray(Object[] parameters) {
        BasicDBList list = new BasicDBList();
        for (Object parameter : parameters) {
            list.add(this.marshallParameter(parameter));
        }
        return list;
    }

    private DBObject marshallCollection(Collection<?> parameters) {
        BasicDBList list = new BasicDBList();
        for (Object param : parameters) {
            list.add(this.marshallParameter(param));
        }
        return list;
    }

    private Object marshallDocument(Object parameter) {
        if (parameter instanceof Enum) {
            return this.marshallParameterAsPrimitive(parameter);
        }
        BsonDocument document = this.marshaller.marshall(parameter);
        if (this.hasBeenSerializedAsPrimitive(document)) {
            return this.marshallParameterAsPrimitive(parameter);
        }
        return document.toDBObject();
    }

    private boolean hasBeenSerializedAsPrimitive(BsonDocument document) {
        byte[] bytes = document.toByteArray();
        if (bytes.length > 4) {
            return bytes.length != document.getSize();
        }
        return true;
    }

    private Object marshallParameterAsPrimitive(Object parameter) {
        Map<String, Object> primitiveWrapper = Collections.singletonMap("wrapped", parameter);
        BsonDocument document = this.marshaller.marshall(primitiveWrapper);
        return document.toDBObject().get("wrapped");
    }

    private static class BsonQuery
    implements Query {
        private final DBObject dbo;

        public BsonQuery(DBObject dbo) {
            this.dbo = dbo;
        }

        public DBObject toDBObject() {
            return this.dbo;
        }
    }
}

