/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.DBMaker$Maker$WhenMappings;
import org.mapdb.DataIO;
import org.mapdb.Store;
import org.mapdb.StoreDirect;
import org.mapdb.StoreOnHeap;
import org.mapdb.StoreReadOnlyWrapper;
import org.mapdb.StoreWAL;
import org.mapdb.volume.ByteArrayVol;
import org.mapdb.volume.ByteBufferMemoryVol;
import org.mapdb.volume.FileChannelVol;
import org.mapdb.volume.MappedFileVol;
import org.mapdb.volume.RandomAccessFileVol;
import org.mapdb.volume.ReadOnlyVolumeFactory;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\u0018\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a8\u0006\u001b"}, d2={"Lorg/mapdb/DBMaker;", "", "()V", "fileDB", "Lorg/mapdb/DBMaker$Maker;", "file", "Ljava/io/File;", "", "heapDB", "heapShardedHashMap", "Lorg/mapdb/DB$HashMapMaker;", "concurrency", "", "heapShardedHashSet", "Lorg/mapdb/DB$HashSetMaker;", "memoryDB", "memoryDirectDB", "memoryShardedHashMap", "memoryShardedHashSet", "tempFileDB", "volumeDB", "volume", "Lorg/mapdb/volume/Volume;", "volumeExists", "", "Maker", "StoreType", "mapdb"})
public final class DBMaker {
    public static final DBMaker INSTANCE;

    @JvmStatic
    @NotNull
    public static final Maker tempFileDB() {
        File file = File.createTempFile("mapdb", "temp");
        file.delete();
        file.deleteOnExit();
        File file2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
        return DBMaker.fileDB(file2).deleteFilesAfterClose();
    }

    @JvmStatic
    @NotNull
    public static final Maker fileDB(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new Maker(StoreType.fileRaf, null, null, file, 6, null);
    }

    @JvmStatic
    @NotNull
    public static final Maker fileDB(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        return DBMaker.fileDB(string);
    }

    @JvmStatic
    @NotNull
    public static final Maker heapDB() {
        return new Maker(StoreType.onheap, null, null, null, 14, null);
    }

    @JvmStatic
    @NotNull
    public static final Maker memoryDB() {
        return new Maker(StoreType.bytearray, null, null, null, 14, null);
    }

    @JvmStatic
    @NotNull
    public static final Maker memoryDirectDB() {
        return new Maker(StoreType.directbuffer, null, null, null, 14, null);
    }

    @JvmStatic
    @NotNull
    public static final Maker volumeDB(@NotNull Volume volume2, boolean volumeExists) {
        Intrinsics.checkParameterIsNotNull((Object)volume2, (String)"volume");
        return new Maker(null, volume2, volumeExists, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final DB.HashSetMaker<?> memoryShardedHashSet(int concurrency) {
        DB db = new DB(new StoreOnHeap(false, 1, null), false, true, null, 0, 24, null);
        return new DB.HashSetMaker(db, "map", (Function1<? super Integer, ? extends Store>)((Function1)memoryShardedHashSet.1.INSTANCE)).layout(concurrency, 1 << 7, 4);
    }

    @JvmStatic
    @NotNull
    public static final DB.HashSetMaker<?> heapShardedHashSet(int concurrency) {
        DB db = new DB(new StoreOnHeap(false, 1, null), false, true, null, 0, 24, null);
        return new DB.HashSetMaker(db, "map", (Function1<? super Integer, ? extends Store>)((Function1)heapShardedHashSet.1.INSTANCE)).layout(concurrency, 1 << 7, 4);
    }

    @JvmStatic
    @NotNull
    public static final DB.HashMapMaker<?, ?> memoryShardedHashMap(int concurrency) {
        DB db = new DB(new StoreOnHeap(false, 1, null), false, true, null, 0, 24, null);
        return new DB.HashMapMaker(db, "map", false, memoryShardedHashMap.1.INSTANCE, 4, null).layout(concurrency, 1 << 7, 4);
    }

    @JvmStatic
    @NotNull
    public static final DB.HashMapMaker<?, ?> heapShardedHashMap(int concurrency) {
        DB db = new DB(new StoreOnHeap(false, 1, null), false, true, null, 0, 24, null);
        return new DB.HashMapMaker(db, "map", false, heapShardedHashMap.1.INSTANCE, 4, null).layout(concurrency, 1 << 7, 4);
    }

    private DBMaker() {
        INSTANCE = this;
    }

    static {
        new DBMaker();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/mapdb/DBMaker$StoreType;", "", "(Ljava/lang/String;I)V", "onheap", "directbuffer", "bytearray", "fileRaf", "fileMMap", "fileChannel", "mapdb"})
    public static final class StoreType
    extends Enum<StoreType> {
        public static final /* enum */ StoreType onheap;
        public static final /* enum */ StoreType directbuffer;
        public static final /* enum */ StoreType bytearray;
        public static final /* enum */ StoreType fileRaf;
        public static final /* enum */ StoreType fileMMap;
        public static final /* enum */ StoreType fileChannel;
        private static final /* synthetic */ StoreType[] $VALUES;

        static {
            StoreType[] storeTypeArray = new StoreType[6];
            StoreType[] storeTypeArray2 = storeTypeArray;
            storeTypeArray[0] = onheap = new StoreType();
            storeTypeArray[1] = directbuffer = new StoreType();
            storeTypeArray[2] = bytearray = new StoreType();
            storeTypeArray[3] = fileRaf = new StoreType();
            storeTypeArray[4] = fileMMap = new StoreType();
            storeTypeArray[5] = fileChannel = new StoreType();
            $VALUES = storeTypeArray;
        }

        public static StoreType[] values() {
            return (StoreType[])$VALUES.clone();
        }

        public static StoreType valueOf(String string) {
            return Enum.valueOf(StoreType.class, string);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\fJ\b\u0010!\u001a\u00020\"H\u0004J\u0006\u0010#\u001a\u00020\u0000J\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020\u0000J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0012J\b\u0010+\u001a\u00020\u0000H\u0007J\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0000J\u0006\u0010.\u001a\u00020\u0000J\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0000J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\fJ\u0006\u00103\u001a\u00020\u0000J\u0006\u00104\u001a\u00020\u0000J\u0006\u00105\u001a\u00020\u0000J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u00020\u0000J\u0006\u00109\u001a\u00020\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/mapdb/DBMaker$Maker;", "", "_storeType", "Lorg/mapdb/DBMaker$StoreType;", "_customVolume", "Lorg/mapdb/volume/Volume;", "_volumeExist", "", "file", "", "(Lorg/mapdb/DBMaker$StoreType;Lorg/mapdb/volume/Volume;Ljava/lang/Boolean;Ljava/lang/String;)V", "_allocateIncrement", "", "_allocateStartSize", "_checksumHeaderBypass", "_checksumStoreEnable", "_cleanerHack", "_closeOnJvmShutdown", "", "_concurrencyScale", "_fileDeleteAfterClose", "_fileDeleteAfterOpen", "_fileLockWait", "_fileMmapPreclearDisable", "_fileMmapfIfSupported", "_isThreadSafe", "_readOnly", "_transactionEnable", "Ljava/lang/Boolean;", "allocateIncrement", "incrementSize", "allocateStartSize", "size", "assertFile", "", "checksumHeaderBypass", "checksumStoreEnable", "cleanerHackEnable", "closeOnJvmShutdown", "closeOnJvmShutdownWeakReference", "concurrencyDisable", "concurrencyScale", "segmentCount", "deleteFilesAfterClose", "executorEnable", "fileChannelEnable", "fileDeleteAfterClose", "fileDeleteAfterOpen", "fileLockDisable", "fileLockWait", "timeout", "fileMmapEnable", "fileMmapEnableIfSupported", "fileMmapPreclearDisable", "make", "Lorg/mapdb/DB;", "readOnly", "transactionEnable", "mapdb"})
    public static final class Maker {
        private long _allocateStartSize;
        private long _allocateIncrement;
        private boolean _transactionEnable;
        private boolean _fileDeleteAfterClose;
        private boolean _fileDeleteAfterOpen;
        private boolean _isThreadSafe;
        private int _concurrencyScale;
        private boolean _cleanerHack;
        private boolean _fileMmapPreclearDisable;
        private long _fileLockWait;
        private boolean _fileMmapfIfSupported;
        private int _closeOnJvmShutdown;
        private boolean _readOnly;
        private boolean _checksumStoreEnable;
        private boolean _checksumHeaderBypass;
        private StoreType _storeType;
        private final Volume _customVolume;
        private final Boolean _volumeExist;
        private final String file;

        @NotNull
        public final Maker transactionEnable() {
            this._transactionEnable = true;
            return this;
        }

        @NotNull
        public final Maker allocateStartSize(long size2) {
            this._allocateStartSize = size2;
            return this;
        }

        @NotNull
        public final Maker allocateIncrement(long incrementSize) {
            this._allocateIncrement = incrementSize;
            return this;
        }

        @Deprecated(message="method renamed to `fileDeleteAfterClose()`")
        @NotNull
        public final Maker deleteFilesAfterClose() {
            this._fileDeleteAfterClose = true;
            return this;
        }

        @NotNull
        public final Maker fileDeleteAfterClose() {
            this._fileDeleteAfterClose = true;
            return this;
        }

        @NotNull
        public final Maker fileDeleteAfterOpen() {
            this._fileDeleteAfterOpen = true;
            return this;
        }

        @NotNull
        public final Maker executorEnable() {
            return this;
        }

        @NotNull
        public final Maker concurrencyDisable() {
            this._isThreadSafe = false;
            return this;
        }

        @NotNull
        public final Maker concurrencyScale(int segmentCount) {
            this._concurrencyScale = segmentCount;
            return this;
        }

        protected final void assertFile() {
            StoreType[] elements$iv = new StoreType[]{StoreType.fileRaf, StoreType.fileMMap, StoreType.fileChannel};
            if (!ArraysKt.contains((Object[])((Object[])elements$iv), (Object)((Object)this._storeType))) {
                throw (Throwable)new DBException.WrongConfiguration("File related options are not allowed for in-memory store");
            }
        }

        @NotNull
        public final Maker fileMmapEnable() {
            this.assertFile();
            this._storeType = StoreType.fileMMap;
            return this;
        }

        @NotNull
        public final Maker cleanerHackEnable() {
            this._cleanerHack = true;
            return this;
        }

        @NotNull
        public final Maker fileMmapPreclearDisable() {
            this._fileMmapPreclearDisable = true;
            return this;
        }

        @NotNull
        public final Maker fileLockDisable() {
            this.assertFile();
            this._fileLockWait = -1L;
            return this;
        }

        @NotNull
        public final Maker fileLockWait(long timeout) {
            this.assertFile();
            this._fileLockWait = timeout;
            return this;
        }

        @NotNull
        public final Maker fileLockWait() {
            return this.fileLockWait(LongCompanionObject.MAX_VALUE);
        }

        @NotNull
        public final Maker checksumStoreEnable() {
            this._checksumStoreEnable = true;
            return this;
        }

        @NotNull
        public final Maker checksumHeaderBypass() {
            this._checksumHeaderBypass = true;
            return this;
        }

        @NotNull
        public final Maker fileMmapEnableIfSupported() {
            this.assertFile();
            this._fileMmapfIfSupported = true;
            return this;
        }

        @NotNull
        public final Maker fileChannelEnable() {
            this.assertFile();
            this._storeType = StoreType.fileChannel;
            return this;
        }

        @NotNull
        public final Maker closeOnJvmShutdown() {
            this._closeOnJvmShutdown = 1;
            return this;
        }

        @NotNull
        public final Maker closeOnJvmShutdownWeakReference() {
            this._closeOnJvmShutdown = 2;
            return this;
        }

        @NotNull
        public final Maker readOnly() {
            this._readOnly = true;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final DB make() {
            storeOpened = false;
            concShift = DataIO.shift(DataIO.nextPowTwo(this._concurrencyScale));
            storeType2 = this._storeType;
            if (this._fileMmapfIfSupported && DataIO.JVMSupportsLargeMappedFiles()) {
                storeType2 = StoreType.fileMMap;
            }
            v0 = storeType2;
            if (v0 == null) ** GOTO lbl30
            switch (DBMaker$Maker$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case 1: {
                    v1 = null;
                    break;
                }
                case 2: {
                    v1 = ByteArrayVol.FACTORY;
                    break;
                }
                case 3: {
                    if (this._cleanerHack) {
                        v1 = ByteBufferMemoryVol.FACTORY_WITH_CLEANER_HACK;
                        break;
                    }
                    v1 = ByteBufferMemoryVol.FACTORY;
                    break;
                }
                case 4: {
                    v1 = RandomAccessFileVol.FACTORY;
                    break;
                }
                case 5: {
                    v1 = FileChannelVol.FACTORY;
                    break;
                }
                case 6: {
                    v1 = new MappedFileVol.MappedFileFactory(this._cleanerHack, this._fileMmapPreclearDisable);
                    break;
                }
lbl30:
                // 1 sources

                v2 = this._customVolume;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                v3 = this._volumeExist;
                if (v3 == null) {
                    Intrinsics.throwNpe();
                }
                v1 = VolumeFactory.wrap(v2, v3);
                break;
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            volfab = v1;
            if (this._readOnly && volfab != null && !volfab.handlesReadonly()) {
                volfab = new ReadOnlyVolumeFactory(volfab);
            }
            if (Intrinsics.areEqual((Object)this._storeType, (Object)StoreType.onheap)) {
                v4 = this._readOnly ? (Store)new StoreReadOnlyWrapper(new StoreOnHeap(false, 1, null)) : (Store)new StoreOnHeap(false, 1, null);
            } else {
                v5 = volfab;
                if (v5 == null) {
                    Intrinsics.throwNpe();
                }
                storeOpened = v5.exists(this.file);
                if (!this._transactionEnable || this._readOnly) {
                    v6 = volfab;
                    if (v6 == null) {
                        Intrinsics.throwNpe();
                    }
                    var6_5 = this._checksumHeaderBypass;
                    var7_7 = false;
                    var8_9 = this._isThreadSafe;
                    var9_11 = this._checksumStoreEnable;
                    var10_13 = concShift;
                    var11_15 = this._fileDeleteAfterOpen;
                    var12_17 = this._fileDeleteAfterClose;
                    var13_19 = this._readOnly;
                    var14_21 = this._allocateStartSize;
                    var16_22 = this._allocateIncrement;
                    v7 = StoreDirect.Companion.make$default(StoreDirect.Companion, this.file, v6, this._fileLockWait, var13_19, var8_9, var10_13, var16_22, var14_21, var12_17, var11_15, var9_11, var7_7, var6_5, 2048, null);
                } else {
                    if (this._checksumStoreEnable) {
                        throw (Throwable)new DBException.WrongConfiguration("Checksum is not supported with transaction enabled.");
                    }
                    v8 = volfab;
                    if (v8 == null) {
                        Intrinsics.throwNpe();
                    }
                    var6_6 = this._checksumHeaderBypass;
                    var7_8 = false;
                    var8_10 = this._isThreadSafe;
                    var9_12 = this._checksumStoreEnable;
                    var10_14 = concShift;
                    var11_16 = this._fileDeleteAfterOpen;
                    var12_18 = this._fileDeleteAfterClose;
                    var13_20 = this._allocateStartSize;
                    var15_23 = this._allocateIncrement;
                    v7 = StoreWAL.Companion.make$default(StoreWAL.Companion, this.file, v8, this._fileLockWait, var8_10, var10_14, var15_23, var13_20, var12_18, var11_16, var9_12, var7_8, var6_6, 1024, null);
                }
                v4 = v7;
            }
            store = v4;
            return new DB(store, storeOpened, this._isThreadSafe, null, this._closeOnJvmShutdown, 8, null);
        }

        public Maker(@Nullable StoreType _storeType, @Nullable Volume _customVolume, @Nullable Boolean _volumeExist, @Nullable String file) {
            this._storeType = _storeType;
            this._customVolume = _customVolume;
            this._volumeExist = _volumeExist;
            this.file = file;
            this._isThreadSafe = true;
            this._concurrencyScale = 1 << 3;
        }

        public /* synthetic */ Maker(StoreType storeType, Volume volume2, Boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                volume2 = null;
            }
            if ((n & 4) != 0) {
                bl = null;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            this(storeType, volume2, bl, string);
        }
    }
}

