/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.volume.Volume;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public abstract class ByteBufferVol
extends Volume {
    protected final boolean cleanerHackEnabled;
    protected final ReentrantLock growLock = new ReentrantLock();
    protected final int sliceShift;
    protected final int sliceSizeModMask;
    protected final int sliceSize;
    protected volatile ByteBuffer[] slices = new ByteBuffer[0];
    protected final boolean readOnly;
    private static boolean unmapHackSupported = true;
    static boolean windowsWorkaround;

    protected ByteBufferVol(boolean readOnly, int sliceShift, boolean cleanerHackEnabled) {
        this.readOnly = readOnly;
        this.sliceShift = sliceShift;
        this.cleanerHackEnabled = cleanerHackEnabled;
        this.sliceSize = 1 << sliceShift;
        this.sliceSizeModMask = this.sliceSize - 1;
    }

    protected final ByteBuffer getSlice(long offset) {
        int pos = (int)(offset >>> this.sliceShift);
        ByteBuffer[] slices = this.slices;
        if (pos >= slices.length) {
            throw new DBException.VolumeEOF("Get/Set beyond file size. Requested offset: " + offset + ", volume size: " + this.length());
        }
        return slices[pos];
    }

    @Override
    public final void putLong(long offset, long value) {
        this.getSlice(offset).putLong((int)(offset & (long)this.sliceSizeModMask), value);
    }

    @Override
    public final void putInt(long offset, int value) {
        this.getSlice(offset).putInt((int)(offset & (long)this.sliceSizeModMask), value);
    }

    @Override
    public final void putByte(long offset, byte value) {
        this.getSlice(offset).put((int)(offset & (long)this.sliceSizeModMask), value);
    }

    @Override
    public void putData(long offset, byte[] src, int srcPos, int srcSize) {
        ByteBuffer b1 = this.getSlice(offset).duplicate();
        int bufPos = (int)(offset & (long)this.sliceSizeModMask);
        b1.position(bufPos);
        b1.put(src, srcPos, srcSize);
    }

    @Override
    public final void putData(long offset, ByteBuffer buf) {
        ByteBuffer b1 = this.getSlice(offset).duplicate();
        int bufPos = (int)(offset & (long)this.sliceSizeModMask);
        b1.position(bufPos);
        b1.put(buf);
    }

    @Override
    public void copyTo(long inputOffset, Volume target, long targetOffset, long size2) {
        ByteBuffer b1 = this.getSlice(inputOffset).duplicate();
        int bufPos = (int)(inputOffset & (long)this.sliceSizeModMask);
        b1.position(bufPos);
        b1.limit((int)((long)bufPos + size2));
        target.putData(targetOffset, b1);
    }

    @Override
    public void getData(long offset, byte[] src, int srcPos, int srcSize) {
        ByteBuffer b1 = this.getSlice(offset).duplicate();
        int bufPos = (int)(offset & (long)this.sliceSizeModMask);
        b1.position(bufPos);
        b1.get(src, srcPos, srcSize);
    }

    @Override
    public final long getLong(long offset) {
        return this.getSlice(offset).getLong((int)(offset & (long)this.sliceSizeModMask));
    }

    @Override
    public final int getInt(long offset) {
        return this.getSlice(offset).getInt((int)(offset & (long)this.sliceSizeModMask));
    }

    @Override
    public final byte getByte(long offset) {
        return this.getSlice(offset).get((int)(offset & (long)this.sliceSizeModMask));
    }

    @Override
    public final DataInput2.ByteBuffer getDataInput(long offset, int size2) {
        return new DataInput2.ByteBuffer(this.getSlice(offset), (int)(offset & (long)this.sliceSizeModMask));
    }

    @Override
    public void putDataOverlap(long offset, byte[] data, int pos, int len) {
        boolean overlap;
        boolean bl = overlap = offset >>> this.sliceShift != offset + (long)len >>> this.sliceShift;
        if (overlap) {
            while (len > 0) {
                ByteBuffer b = this.getSlice(offset).duplicate();
                b.position((int)(offset & (long)this.sliceSizeModMask));
                int toPut = Math.min(len, this.sliceSize - b.position());
                b.limit(b.position() + toPut);
                b.put(data, pos, toPut);
                pos += toPut;
                len -= toPut;
                offset += (long)toPut;
            }
        } else {
            this.putData(offset, data, pos, len);
        }
    }

    @Override
    public DataInput2 getDataInputOverlap(long offset, int size2) {
        boolean overlap;
        boolean bl = overlap = offset >>> this.sliceShift != offset + (long)size2 >>> this.sliceShift;
        if (overlap) {
            byte[] bb = new byte[size2];
            int origLen = size2;
            while (size2 > 0) {
                ByteBuffer b = this.getSlice(offset).duplicate();
                b.position((int)(offset & (long)this.sliceSizeModMask));
                int toPut = Math.min(size2, this.sliceSize - b.position());
                b.limit(b.position() + toPut);
                b.get(bb, origLen - size2, toPut);
                size2 -= toPut;
                offset += (long)toPut;
            }
            return new DataInput2.ByteArray(bb);
        }
        return this.getDataInput(offset, size2);
    }

    @Override
    public void putUnsignedShort(long offset, int value) {
        ByteBuffer b = this.getSlice(offset);
        int bpos = (int)(offset & (long)this.sliceSizeModMask);
        b.put(bpos++, (byte)(value >> 8));
        b.put(bpos, (byte)value);
    }

    @Override
    public int getUnsignedShort(long offset) {
        ByteBuffer b = this.getSlice(offset);
        int bpos = (int)(offset & (long)this.sliceSizeModMask);
        return (b.get(bpos++) & 0xFF) << 8 | b.get(bpos) & 0xFF;
    }

    @Override
    public int getUnsignedByte(long offset) {
        ByteBuffer b = this.getSlice(offset);
        int bpos = (int)(offset & (long)this.sliceSizeModMask);
        return b.get(bpos) & 0xFF;
    }

    @Override
    public void putUnsignedByte(long offset, int byt) {
        ByteBuffer b = this.getSlice(offset);
        int bpos = (int)(offset & (long)this.sliceSizeModMask);
        b.put(bpos, ByteBufferVol.toByte(byt));
    }

    protected static byte toByte(int byt) {
        return (byte)(byt & 0xFF);
    }

    protected static byte toByte(long l) {
        return (byte)(l & 0xFFL);
    }

    @Override
    public long getSixLong(long pos) {
        ByteBuffer bb = this.getSlice(pos);
        int bpos = (int)(pos & (long)this.sliceSizeModMask);
        return (long)(bb.get(bpos++) & 0xFF) << 40 | (long)(bb.get(bpos++) & 0xFF) << 32 | (long)(bb.get(bpos++) & 0xFF) << 24 | (long)(bb.get(bpos++) & 0xFF) << 16 | (long)(bb.get(bpos++) & 0xFF) << 8 | (long)(bb.get(bpos) & 0xFF);
    }

    @Override
    public void putSixLong(long pos, long value) {
        ByteBuffer b = this.getSlice(pos);
        int bpos = (int)(pos & (long)this.sliceSizeModMask);
        if (value >>> 48 != 0L) {
            throw new DBException.DataCorruption("six long out of range");
        }
        b.put(bpos++, (byte)(0xFFL & value >> 40));
        b.put(bpos++, (byte)(0xFFL & value >> 32));
        b.put(bpos++, (byte)(0xFFL & value >> 24));
        b.put(bpos++, (byte)(0xFFL & value >> 16));
        b.put(bpos++, (byte)(0xFFL & value >> 8));
        b.put(bpos, (byte)(0xFFL & value));
    }

    @Override
    public int putPackedLong(long pos, long value) {
        ByteBuffer b = this.getSlice(pos);
        int bpos = (int)(pos & (long)this.sliceSizeModMask);
        int ret2 = 0;
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            b.put(bpos + ret2++, (byte)(value >>> shift & 0x7FL));
            shift -= 7;
        }
        b.put(bpos + ret2++, (byte)(value & 0x7FL | 0x80L));
        return ret2;
    }

    @Override
    public long getPackedLong(long position) {
        byte v;
        ByteBuffer b = this.getSlice(position);
        int bpos = (int)(position & (long)this.sliceSizeModMask);
        long ret2 = 0L;
        int pos2 = 0;
        do {
            v = b.get(bpos + pos2++);
            ret2 = ret2 << 7 | (long)(v & 0x7F);
        } while ((v & 0x80) == 0);
        return (long)pos2 << 60 | ret2;
    }

    @Override
    public void clear(long startOffset, long endOffset) {
        if (startOffset >>> this.sliceShift != endOffset - 1L >>> this.sliceShift) {
            throw new AssertionError();
        }
        ByteBuffer buf = this.getSlice(startOffset);
        int start = (int)(startOffset & (long)this.sliceSizeModMask);
        int end = (int)((long)start + (endOffset - startOffset));
        for (int pos = start; pos < end; pos += CLEAR.length) {
            buf = buf.duplicate();
            buf.position(pos);
            buf.put(CLEAR, 0, Math.min(CLEAR.length, end - pos));
        }
    }

    @Override
    public boolean isSliced() {
        return true;
    }

    @Override
    public int sliceSize() {
        return this.sliceSize;
    }

    protected static boolean unmap(MappedByteBuffer b) {
        if (!unmapHackSupported) {
            return false;
        }
        if (!(b instanceof DirectBuffer)) {
            return false;
        }
        DirectBuffer bb = (DirectBuffer)((Object)b);
        Cleaner c = bb.cleaner();
        if (c != null) {
            c.clean();
            return true;
        }
        Object attachment = bb.attachment();
        return attachment != null && attachment instanceof DirectBuffer && ByteBufferVol.unmap(b);
    }

    static {
        try {
            unmapHackSupported = Thread.currentThread().getContextClassLoader().loadClass("sun.nio.ch.DirectBuffer") != null;
        }
        catch (Exception e) {
            LOG.warning("mmap file unmap hack not supported, mmap files will not be closed, sun.nio.ch.DirectBuffer not found");
            unmapHackSupported = false;
        }
        windowsWorkaround = System.getProperty("os.name").toLowerCase().startsWith("win");
    }
}

