/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.bytebuddy.build;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.modelmapper.internal.asm.AnnotationVisitor;
import org.modelmapper.internal.asm.ClassVisitor;
import org.modelmapper.internal.asm.Type;
import org.modelmapper.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.modelmapper.internal.bytebuddy.build.Plugin;
import org.modelmapper.internal.bytebuddy.description.method.MethodDescription;
import org.modelmapper.internal.bytebuddy.description.method.MethodList;
import org.modelmapper.internal.bytebuddy.description.type.TypeDescription;
import org.modelmapper.internal.bytebuddy.dynamic.ClassFileLocator;
import org.modelmapper.internal.bytebuddy.dynamic.DynamicType;
import org.modelmapper.internal.bytebuddy.implementation.attribute.AnnotationValueFilter;
import org.modelmapper.internal.bytebuddy.implementation.attribute.TypeAttributeAppender;
import org.modelmapper.internal.bytebuddy.matcher.ElementMatchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class RepeatedAnnotationPlugin
extends Plugin.ForElementMatcher {
    private static final MethodDescription.InDefinedShape VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Enhance.class).getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly();

    public RepeatedAnnotationPlugin() {
        super(ElementMatchers.isAnnotatedWith(Enhance.class));
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        TypeDescription target = typeDescription.getDeclaredAnnotations().ofType(Enhance.class).getValue(VALUE).resolve(TypeDescription.class);
        if (!target.isAnnotation()) {
            throw new IllegalStateException("Expected " + target + " to be an annotation type");
        }
        if (target.getDeclaredMethods().size() != 1 || ((MethodList)target.getDeclaredMethods().filter(ElementMatchers.named("value"))).size() != 1 || !((MethodDescription.InDefinedShape)((MethodList)target.getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly()).getReturnType().isArray() || !((MethodDescription.InDefinedShape)((MethodList)target.getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly()).getReturnType().getComponentType().asErasure().equals(typeDescription)) {
            throw new IllegalStateException("Expected " + target + " to declare exactly one property named value of an array type");
        }
        return builder.attribute(new RepeatedAnnotationAppender(target));
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class RepeatedAnnotationAppender
    implements TypeAttributeAppender {
        private final TypeDescription target;

        protected RepeatedAnnotationAppender(TypeDescription target) {
            this.target = target;
        }

        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            AnnotationVisitor visitor = classVisitor.visitAnnotation("Ljava/lang/annotation/Repeatable;", true);
            if (visitor != null) {
                visitor.visit("value", Type.getType(this.target.getDescriptor()));
                visitor.visitEnd();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.target.equals(((RepeatedAnnotationAppender)object).target);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.target.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Documented
    @Target(value={ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
        public Class<? extends Annotation> value();
    }
}

