/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.Loggable;
import com.p6spy.engine.logging.Category;
import com.p6spy.engine.logging.P6LogLoadableOptions;
import com.p6spy.engine.logging.P6LogOptions;
import com.p6spy.engine.spy.P6ModuleManager;
import com.p6spy.engine.spy.P6SpyOptions;
import com.p6spy.engine.spy.appender.FileLogger;
import com.p6spy.engine.spy.appender.FormattedLogger;
import com.p6spy.engine.spy.appender.MessageFormattingStrategy;
import com.p6spy.engine.spy.appender.P6Logger;
import com.p6spy.engine.spy.option.P6OptionChangedListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class P6LogQuery
implements P6OptionChangedListener {
    private static final Set<Category> CATEGORIES_IMPLICITLY_INCLUDED = new HashSet<Category>(Arrays.asList(Category.ERROR, Category.OUTAGE));
    private static final Set<String> ON_CHANGE = new HashSet<String>(Arrays.asList("appenderInstance", "logfile", "logMessageFormatInstance"));
    protected static P6Logger logger;

    @Override
    public void optionChanged(String key, Object oldValue, Object newValue) {
        if (ON_CHANGE.contains(key)) {
            P6LogQuery.initialize();
        }
    }

    public static synchronized void initialize() {
        P6ModuleManager moduleManager = P6ModuleManager.getInstance();
        if (null == moduleManager) {
            return;
        }
        P6SpyOptions opts = moduleManager.getOptions(P6SpyOptions.class);
        logger = opts.getAppenderInstance();
        if (logger != null) {
            MessageFormattingStrategy strategy;
            if (logger instanceof FileLogger) {
                String logfile = opts.getLogfile();
                ((FileLogger)logger).setLogfile(logfile);
            }
            if (logger instanceof FormattedLogger && (strategy = opts.getLogMessageFormatInstance()) != null) {
                ((FormattedLogger)logger).setStrategy(strategy);
            }
        }
    }

    protected static void doLog(long elapsed, Category category, String prepared, String sql) {
        P6LogQuery.doLog(-1, elapsed, category, prepared, sql, "");
    }

    protected static void doLogElapsed(int connectionId, long timeElapsedNanos, Category category, String prepared, String sql, String url) {
        P6LogQuery.doLog(connectionId, timeElapsedNanos, category, prepared, sql, url);
    }

    protected static void doLog(int connectionId, long elapsedNanos, Category category, String prepared, String sql, String url) {
        String format;
        if (logger == null) {
            P6LogQuery.initialize();
            if (logger == null) {
                return;
            }
        }
        String stringNow = (format = P6SpyOptions.getActiveInstance().getDateformat()) == null ? Long.toString(System.currentTimeMillis()) : new SimpleDateFormat(format).format(new Date()).trim();
        logger.logSQL(connectionId, stringNow, TimeUnit.NANOSECONDS.toMillis(elapsedNanos), category, prepared, sql, url);
        boolean stackTrace = P6SpyOptions.getActiveInstance().getStackTrace();
        if (stackTrace) {
            String stackTraceClass = P6SpyOptions.getActiveInstance().getStackTraceClass();
            Exception e = new Exception();
            if (stackTraceClass != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String stack = sw.toString();
                if (stack.indexOf(stackTraceClass) == -1) {
                    e = null;
                }
            }
            if (e != null) {
                logger.logException(e);
            }
        }
    }

    static boolean isLoggable(String sql) {
        if (null == sql) {
            return false;
        }
        P6LogLoadableOptions opts = P6LogOptions.getActiveInstance();
        if (!opts.getFilter()) {
            return true;
        }
        Pattern sqlExpressionPattern = opts.getSQLExpressionPattern();
        Pattern includeExcludePattern = opts.getIncludeExcludePattern();
        return !(sqlExpressionPattern != null && !sqlExpressionPattern.matcher(sql).matches() || includeExcludePattern != null && !includeExcludePattern.matcher(sql).matches());
    }

    static boolean isCategoryOk(Category category) {
        P6LogLoadableOptions opts = P6LogOptions.getActiveInstance();
        if (null == opts) {
            return CATEGORIES_IMPLICITLY_INCLUDED.contains(category);
        }
        Set<Category> excludeCategories = opts.getExcludeCategoriesSet();
        return logger != null && logger.isCategoryEnabled(category) && (excludeCategories == null || !excludeCategories.contains(category));
    }

    public static void log(Category category, String prepared, String sql) {
        if (logger != null && P6LogQuery.isCategoryOk(category)) {
            P6LogQuery.doLog(-1L, category, prepared, sql);
        }
    }

    public static void log(Category category, Loggable loggable) {
        if (logger != null && P6LogQuery.isCategoryOk(category) && P6LogQuery.isLoggable(loggable.getSql())) {
            P6LogQuery.doLog(-1L, category, loggable.getSql(), loggable.getSqlWithValues());
        }
    }

    public static void logElapsed(int connectionId, long timeElapsedNanos, Category category, String prepared, String sql, String url) {
        if (logger != null && P6LogQuery.meetsThresholdRequirement(timeElapsedNanos) && P6LogQuery.isCategoryOk(category) && P6LogQuery.isLoggable(sql)) {
            P6LogQuery.doLogElapsed(connectionId, timeElapsedNanos, category, prepared, sql, url == null ? "" : url);
        } else if (P6LogQuery.isDebugEnabled()) {
            P6LogQuery.debug("P6Spy intentionally did not log category: " + category + ", statement: " + sql + "  Reason: logger=" + logger + ", isLoggable=" + P6LogQuery.isLoggable(sql) + ", isCategoryOk=" + P6LogQuery.isCategoryOk(category) + ", meetsTreshold=" + P6LogQuery.meetsThresholdRequirement(timeElapsedNanos));
        }
    }

    public static void logElapsed(int connectionId, long timeElapsedNanos, Category category, Loggable loggable) {
        String sql = loggable.getSql();
        String url = loggable.getConnectionInformation().getUrl();
        if (logger != null && P6LogQuery.meetsThresholdRequirement(timeElapsedNanos) && P6LogQuery.isCategoryOk(category) && P6LogQuery.isLoggable(sql)) {
            P6LogQuery.doLogElapsed(connectionId, timeElapsedNanos, category, sql, loggable.getSqlWithValues(), url == null ? "" : url);
        } else if (P6LogQuery.isDebugEnabled()) {
            sql = loggable.getSqlWithValues();
            P6LogQuery.debug("P6Spy intentionally did not log category: " + category + ", statement: " + sql + "  Reason: logger=" + logger + ", isLoggable=" + P6LogQuery.isLoggable(sql) + ", isCategoryOk=" + P6LogQuery.isCategoryOk(category) + ", meetsTreshold=" + P6LogQuery.meetsThresholdRequirement(timeElapsedNanos));
        }
    }

    private static boolean meetsThresholdRequirement(long timeTaken) {
        P6LogLoadableOptions opts = P6LogOptions.getActiveInstance();
        long executionThreshold = null != opts ? opts.getExecutionThreshold() : 0L;
        return executionThreshold <= 0L || TimeUnit.NANOSECONDS.toMillis(timeTaken) > executionThreshold;
    }

    public static void info(String sql) {
        if (logger != null && P6LogQuery.isCategoryOk(Category.INFO)) {
            P6LogQuery.doLog(-1L, Category.INFO, "", sql);
        }
    }

    public static boolean isDebugEnabled() {
        return P6LogQuery.isCategoryOk(Category.DEBUG);
    }

    public static void debug(String sql) {
        if (P6LogQuery.isDebugEnabled()) {
            if (logger != null) {
                P6LogQuery.doLog(-1L, Category.DEBUG, "", sql);
            } else {
                System.err.println(sql);
            }
        }
    }

    public static void error(String sql) {
        System.err.println("Warning: " + sql);
        if (logger != null) {
            P6LogQuery.doLog(-1L, Category.ERROR, "", sql);
        }
    }

    public static P6Logger getLogger() {
        return logger;
    }

    static {
        P6LogQuery.initialize();
    }
}

