/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.Loggable;
import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.common.Value;
import com.p6spy.engine.logging.Category;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResultSetInformation
implements Loggable {
    private final StatementInformation statementInformation;
    private String query;
    private final Map<String, Value> resultMap = new LinkedHashMap<String, Value>();
    private int currRow = -1;
    private int lastRowLogged = -1;

    public ResultSetInformation(StatementInformation statementInformation) {
        this.statementInformation = statementInformation;
        this.query = statementInformation.getStatementQuery();
    }

    public void generateLogMessage() {
        if (this.lastRowLogged != this.currRow) {
            P6LogQuery.log(Category.RESULTSET, this);
            this.resultMap.clear();
            this.lastRowLogged = this.currRow;
        }
    }

    public int getCurrRow() {
        return this.currRow;
    }

    public void incrementCurrRow() {
        ++this.currRow;
    }

    public void setColumnValue(String columnName, Object value) {
        this.resultMap.put(columnName, new Value(value));
    }

    @Override
    public String getSql() {
        return this.query;
    }

    @Override
    public String getSqlWithValues() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Value> entry : this.resultMap.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(entry.getValue() != null ? entry.getValue().toString() : new Value().toString());
        }
        return sb.toString();
    }

    public StatementInformation getStatementInformation() {
        return this.statementInformation;
    }

    @Override
    public ConnectionInformation getConnectionInformation() {
        return this.statementInformation.getConnectionInformation();
    }
}

