/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.logging.P6LogOptions;
import com.p6spy.engine.spy.P6SpyOptions;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Value {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private Object value;

    public Value(Object valueToSet) {
        this();
        this.value = valueToSet;
    }

    public Value() {
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return this.convertToString(this.value);
    }

    public String convertToString(Object value) {
        String result;
        if (value == null) {
            result = "NULL";
        } else {
            result = value instanceof Timestamp ? new SimpleDateFormat(P6SpyOptions.getActiveInstance().getDatabaseDialectTimestampFormat()).format(value) : (value instanceof Date ? new SimpleDateFormat(P6SpyOptions.getActiveInstance().getDatabaseDialectDateFormat()).format(value) : (value instanceof Boolean ? ("numeric".equals(P6SpyOptions.getActiveInstance().getDatabaseDialectBooleanFormat()) ? (Boolean.FALSE.equals(value) ? "0" : "1") : value.toString()) : (value instanceof byte[] ? (P6LogOptions.getActiveInstance().getExcludebinary() ? "[binary]" : this.toHexString((byte[])value)) : value.toString())));
            result = this.quoteIfNeeded(result, value);
        }
        return result;
    }

    private String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int temp = b & 0xFF;
            sb.append(HEX_CHARS[temp / 16]);
            sb.append(HEX_CHARS[temp % 16]);
        }
        return sb.toString();
    }

    private String quoteIfNeeded(String stringValue, Object obj) {
        if (stringValue == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(obj.getClass()) || Boolean.class.isAssignableFrom(obj.getClass())) {
            return stringValue;
        }
        return "'" + this.escape(stringValue) + "'";
    }

    private String escape(String stringValue) {
        return stringValue.replaceAll("'", "''");
    }
}

