/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.logging;

import com.p6spy.engine.common.P6Util;
import com.p6spy.engine.logging.Category;
import com.p6spy.engine.logging.P6LogLoadableOptions;
import com.p6spy.engine.logging.P6LogOptionsMBean;
import com.p6spy.engine.spy.P6ModuleManager;
import com.p6spy.engine.spy.option.P6OptionsRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.StandardMBean;

public class P6LogOptions
extends StandardMBean
implements P6LogLoadableOptions {
    public static final String EXCLUDE = "exclude";
    public static final String INCLUDE = "include";
    public static final String FILTER = "filter";
    public static final String EXCLUDECATEGORIES = "excludecategories";
    public static final String EXCLUDEBINARY = "excludebinary";
    public static final String EXECUTION_THRESHOLD = "executionThreshold";
    public static final String SQLEXPRESSION = "sqlexpression";
    public static final String INCLUDE_LIST = "includeList";
    public static final String EXCLUDE_LIST = "excludeList";
    public static final String INCLUDE_EXCLUDE_PATTERN = "includeExcludePattern";
    public static final String EXCLUDECATEGORIES_SET = "excludecategoriesSet";
    public static final String SQLEXPRESSION_PATTERN = "sqlexpressionPattern";
    protected static final Map<String, String> defaults = new HashMap<String, String>();
    private final P6OptionsRepository optionsRepository;

    public P6LogOptions(P6OptionsRepository optionsRepository) {
        super(P6LogOptionsMBean.class, false);
        this.optionsRepository = optionsRepository;
    }

    @Override
    public void load(Map<String, String> options) {
        this.setSQLExpression(options.get(SQLEXPRESSION));
        this.setExecutionThreshold(options.get(EXECUTION_THRESHOLD));
        this.setExcludecategories(options.get(EXCLUDECATEGORIES));
        this.setFilter(options.get(FILTER));
        this.setInclude(options.get(INCLUDE));
        this.setExclude(options.get(EXCLUDE));
        this.setExcludebinary(options.get(EXCLUDEBINARY));
    }

    public static P6LogLoadableOptions getActiveInstance() {
        return P6ModuleManager.getInstance().getOptions(P6LogOptions.class);
    }

    @Override
    public Map<String, String> getDefaults() {
        return defaults;
    }

    @Override
    public void setExclude(String exclude) {
        this.optionsRepository.setSet(String.class, EXCLUDE_LIST, exclude);
        this.optionsRepository.set(String.class, EXCLUDE, P6Util.joinNullSafe(this.optionsRepository.getSet(String.class, EXCLUDE_LIST), ","));
        this.optionsRepository.setOrUnSet(Pattern.class, INCLUDE_EXCLUDE_PATTERN, this.computeIncludeExcludePattern(), defaults.get(INCLUDE_EXCLUDE_PATTERN));
    }

    private String computeIncludeExcludePattern() {
        String excludes = P6Util.joinNullSafe(this.optionsRepository.getSet(String.class, EXCLUDE_LIST), "|");
        String includes = P6Util.joinNullSafe(this.optionsRepository.getSet(String.class, INCLUDE_LIST), "|");
        if (excludes.length() == 0 && includes.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("(?mis)^");
        if (excludes.length() > 0) {
            sb.append("(?!.*(").append(excludes).append(").*)");
        }
        if (includes.length() > 0) {
            sb.append("(.*(").append(includes).append(").*)");
        } else {
            sb.append("(.*)");
        }
        return sb.append("$").toString();
    }

    @Override
    public String getExclude() {
        return this.optionsRepository.get(String.class, EXCLUDE);
    }

    @Override
    public void setExcludebinary(boolean excludebinary) {
        this.optionsRepository.set(Boolean.class, EXCLUDEBINARY, excludebinary);
    }

    @Override
    public void setExcludebinary(String excludebinary) {
        this.optionsRepository.set(Boolean.class, EXCLUDEBINARY, excludebinary);
    }

    @Override
    public boolean getExcludebinary() {
        return this.optionsRepository.get(Boolean.class, EXCLUDEBINARY);
    }

    @Override
    public void setExcludecategories(String excludecategories) {
        this.optionsRepository.set(String.class, EXCLUDECATEGORIES, excludecategories);
        this.optionsRepository.setSet(Category.class, EXCLUDECATEGORIES_SET, excludecategories);
    }

    @Override
    public String getExcludecategories() {
        return this.optionsRepository.get(String.class, EXCLUDECATEGORIES);
    }

    @Override
    public void setFilter(String filter) {
        this.optionsRepository.set(Boolean.class, FILTER, filter);
    }

    @Override
    public void setFilter(boolean filter) {
        this.optionsRepository.set(Boolean.class, FILTER, filter);
    }

    @Override
    public boolean getFilter() {
        return this.optionsRepository.get(Boolean.class, FILTER);
    }

    @Override
    public void setInclude(String include) {
        this.optionsRepository.setSet(String.class, INCLUDE_LIST, include);
        this.optionsRepository.set(String.class, INCLUDE, P6Util.joinNullSafe(this.optionsRepository.getSet(String.class, INCLUDE_LIST), ","));
        this.optionsRepository.setOrUnSet(Pattern.class, INCLUDE_EXCLUDE_PATTERN, this.computeIncludeExcludePattern(), defaults.get(INCLUDE_EXCLUDE_PATTERN));
    }

    @Override
    public String getInclude() {
        return this.optionsRepository.get(String.class, INCLUDE);
    }

    @Override
    public String getSQLExpression() {
        return this.optionsRepository.get(String.class, SQLEXPRESSION);
    }

    @Override
    public Pattern getSQLExpressionPattern() {
        return this.optionsRepository.get(Pattern.class, SQLEXPRESSION_PATTERN);
    }

    @Override
    public void setSQLExpression(String sqlexpression) {
        this.optionsRepository.set(String.class, SQLEXPRESSION, sqlexpression);
        this.optionsRepository.set(Pattern.class, SQLEXPRESSION_PATTERN, sqlexpression);
    }

    @Override
    public void unSetSQLExpression() {
        this.optionsRepository.setOrUnSet(String.class, SQLEXPRESSION, null, defaults.get(SQLEXPRESSION));
        this.optionsRepository.setOrUnSet(Pattern.class, SQLEXPRESSION_PATTERN, null, defaults.get(SQLEXPRESSION_PATTERN));
    }

    @Override
    public void setExecutionThreshold(String executionThreshold) {
        this.optionsRepository.set(Long.class, EXECUTION_THRESHOLD, executionThreshold);
    }

    @Override
    public void setExecutionThreshold(long executionThreshold) {
        this.optionsRepository.set(Long.class, EXECUTION_THRESHOLD, executionThreshold);
    }

    @Override
    public long getExecutionThreshold() {
        return this.optionsRepository.get(Long.class, EXECUTION_THRESHOLD);
    }

    @Override
    public Set<String> getIncludeList() {
        return this.optionsRepository.getSet(String.class, INCLUDE_LIST);
    }

    @Override
    public Set<String> getExcludeList() {
        return this.optionsRepository.getSet(String.class, EXCLUDE_LIST);
    }

    @Override
    public Pattern getIncludeExcludePattern() {
        return this.optionsRepository.get(Pattern.class, INCLUDE_EXCLUDE_PATTERN);
    }

    @Override
    public Set<Category> getExcludeCategoriesSet() {
        return this.optionsRepository.getSet(Category.class, EXCLUDECATEGORIES_SET);
    }

    static {
        defaults.put(FILTER, Boolean.toString(false));
        defaults.put(EXCLUDECATEGORIES, "info,debug,result,resultset,batch");
        defaults.put(EXCLUDEBINARY, Boolean.toString(false));
        defaults.put(EXECUTION_THRESHOLD, Long.toString(0L));
    }
}

