/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.alipay;

import cn.felord.payment.PayException;
import cn.felord.payment.alipay.AliPayProperties;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.file.IOUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConditionalOnProperty(prefix="ali.pay", name={"v1.app-id"})
@EnableConfigurationProperties(value={AliPayProperties.class})
public class AliPayConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AliPayConfiguration.class);

    @Bean
    public AlipayClient alipayClient(AliPayProperties aliPayProperties) throws AlipayApiException {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        AliPayProperties.V1 v1 = aliPayProperties.getV1();
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        propertyMapper.from(v1::getServerUrl).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setServerUrl(arg_0));
        propertyMapper.from(v1::getAppId).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setAppId(arg_0));
        propertyMapper.from(v1::getAppPrivateKeyPath).as(this::loadFile).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setPrivateKey(arg_0));
        propertyMapper.from(v1::getFormat).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setFormat(arg_0));
        propertyMapper.from(v1::getCharset).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setCharset(arg_0));
        propertyMapper.from(v1::getSignType).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setSignType(arg_0));
        Function<String, String> certStrategyFunc = v1.isClasspathUsed() ? this::loadFile : s -> s;
        propertyMapper.from(v1::getAppCertPublicKeyPath).as(certStrategyFunc).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setCertContent(arg_0));
        propertyMapper.from(v1::getAlipayPublicCertPath).as(certStrategyFunc).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setAlipayPublicCertContent(arg_0));
        propertyMapper.from(v1::getAlipayRootCertPath).as(certStrategyFunc).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setRootCertContent(arg_0));
        return new DefaultAlipayClient(certAlipayRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadFile(String classPath) {
        ClassPathResource resource = new ClassPathResource(classPath);
        try (InputStreamReader inputStreamReader = new InputStreamReader(resource.getInputStream());){
            String string = IOUtils.toString((Reader)inputStreamReader);
            return string;
        }
        catch (IOException e) {
            log.error("ali pay app private key is required ,{}", (Object)e.getMessage());
            throw new PayException("ali pay app private key is required");
        }
    }
}

