/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.WechatTenantService;
import cn.felord.payment.wechat.v3.KeyPairFactory;
import cn.felord.payment.wechat.v3.WechatMetaBean;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.CollectionUtils;

public class InMemoryWechatTenantService
implements WechatTenantService {
    private final WechatPayProperties wechatPayProperties;
    private final ResourceLoader resourceLoader;
    private final Set<WechatMetaBean> cache = new HashSet<WechatMetaBean>();

    @Override
    public Set<WechatMetaBean> loadTenants() {
        if (CollectionUtils.isEmpty(this.cache)) {
            Map<String, WechatPayProperties.V3> v3Map = this.wechatPayProperties.getV3();
            KeyPairFactory keyPairFactory = new KeyPairFactory();
            Set beans = v3Map.entrySet().stream().map(entry -> {
                WechatPayProperties.V3 v3 = (WechatPayProperties.V3)entry.getValue();
                String tenantId = (String)entry.getKey();
                String certPath = v3.getCertPath();
                String certAbsolutePath = v3.getCertAbsolutePath();
                String mchId = v3.getMchId();
                FileSystemResource resource = certAbsolutePath != null ? new FileSystemResource(certAbsolutePath) : this.resourceLoader.getResource(certPath == null ? "classpath:wechat/apiclient_cert.p12" : (certPath.startsWith("classpath:") ? certPath : "classpath:" + certPath));
                WechatMetaBean wechatMetaBean = keyPairFactory.initWechatMetaBean((Resource)resource, mchId);
                wechatMetaBean.setV3(v3);
                wechatMetaBean.setTenantId(tenantId);
                return wechatMetaBean;
            }).collect(Collectors.toSet());
            this.cache.addAll(beans);
        }
        return this.cache;
    }

    public InMemoryWechatTenantService(WechatPayProperties wechatPayProperties, ResourceLoader resourceLoader) {
        this.wechatPayProperties = wechatPayProperties;
        this.resourceLoader = resourceLoader;
    }
}

