/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.v3.WechatMetaBean;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.springframework.core.io.Resource;

public class KeyPairFactory {
    private static final String CERT_ALIAS = "Tenpay Certificate";
    private static final KeyStore PKCS12_KEY_STORE;

    public WechatMetaBean initWechatMetaBean(Resource resource, String keyPass) {
        return this.initWechatMetaBean(resource, CERT_ALIAS, keyPass);
    }

    public WechatMetaBean initWechatMetaBean(Resource resource, String keyAlias, String keyPass) {
        char[] pem = keyPass.toCharArray();
        try {
            PKCS12_KEY_STORE.load(resource.getInputStream(), pem);
            X509Certificate certificate = (X509Certificate)PKCS12_KEY_STORE.getCertificate(keyAlias);
            certificate.checkValidity();
            String serialNumber = certificate.getSerialNumber().toString(16).toUpperCase();
            PublicKey publicKey = certificate.getPublicKey();
            PrivateKey storeKey = (PrivateKey)PKCS12_KEY_STORE.getKey(keyAlias, pem);
            WechatMetaBean wechatMetaBean = new WechatMetaBean();
            wechatMetaBean.setKeyPair(new KeyPair(publicKey, storeKey));
            wechatMetaBean.setSerialNumber(serialNumber);
            return wechatMetaBean;
        }
        catch (Exception e) {
            throw new PayException("Cannot load keys from store: " + resource, e);
        }
    }

    static {
        try {
            PKCS12_KEY_STORE = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            throw new PayException(" wechat pay keystore initialization failed");
        }
    }
}

