/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.v2.WechatPayRedpackApi;
import cn.felord.payment.wechat.v2.WechatPayTransfersApi;
import cn.felord.payment.wechat.v2.WechatV2Client;
import cn.felord.payment.wechat.v3.WechatBatchTransferApi;
import cn.felord.payment.wechat.v3.WechatBrandProfitsharingApi;
import cn.felord.payment.wechat.v3.WechatBusinessCircleApi;
import cn.felord.payment.wechat.v3.WechatCapitalApi;
import cn.felord.payment.wechat.v3.WechatCombinePayApi;
import cn.felord.payment.wechat.v3.WechatComplaintsApi;
import cn.felord.payment.wechat.v3.WechatDirectPayApi;
import cn.felord.payment.wechat.v3.WechatDiscountCardApi;
import cn.felord.payment.wechat.v3.WechatGoldPlanApi;
import cn.felord.payment.wechat.v3.WechatMarketingBusiFavorApi;
import cn.felord.payment.wechat.v3.WechatMarketingFavorApi;
import cn.felord.payment.wechat.v3.WechatMarketingPartnershipApi;
import cn.felord.payment.wechat.v3.WechatMarketingPayGiftActivityApi;
import cn.felord.payment.wechat.v3.WechatMediaApi;
import cn.felord.payment.wechat.v3.WechatMetaBean;
import cn.felord.payment.wechat.v3.WechatPartnerBusinessCircleApi;
import cn.felord.payment.wechat.v3.WechatPartnerPayApi;
import cn.felord.payment.wechat.v3.WechatPartnerProfitsharingApi;
import cn.felord.payment.wechat.v3.WechatPartnerSpecialMchApi;
import cn.felord.payment.wechat.v3.WechatPayCallback;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatPayScoreApi;
import cn.felord.payment.wechat.v3.WechatPayScoreParkingApi;
import cn.felord.payment.wechat.v3.WechatProfitsharingApi;
import cn.felord.payment.wechat.v3.WechatSmartGuideApi;
import cn.felord.payment.wechat.v3.ecommerce.WechatEcommerceApi;

public class WechatApiProvider {
    private final WechatPayClient wechatPayClient;

    public WechatApiProvider(WechatPayClient wechatPayClient) {
        this.wechatPayClient = wechatPayClient;
    }

    public WechatDirectPayApi directPayApi(String tenantId) {
        return new WechatDirectPayApi(this.wechatPayClient, tenantId);
    }

    public WechatPartnerPayApi partnerPayApi(String tenantId) {
        return new WechatPartnerPayApi(this.wechatPayClient, tenantId);
    }

    public WechatCombinePayApi combinePayApi(String tenantId) {
        return new WechatCombinePayApi(this.wechatPayClient, tenantId);
    }

    public WechatPayScoreApi payScoreApi(String tenantId) {
        return new WechatPayScoreApi(this.wechatPayClient, tenantId);
    }

    public WechatPayScoreParkingApi payScoreParkingApi(String tenantId) {
        return new WechatPayScoreParkingApi(this.wechatPayClient, tenantId);
    }

    public WechatDiscountCardApi discountCardApi(String tenantId) {
        return new WechatDiscountCardApi(this.wechatPayClient, tenantId);
    }

    public WechatMarketingFavorApi favorApi(String tenantId) {
        return new WechatMarketingFavorApi(this.wechatPayClient, tenantId);
    }

    public WechatMarketingBusiFavorApi busiFavorApi(String tenantId) {
        return new WechatMarketingBusiFavorApi(this.wechatPayClient, tenantId);
    }

    public WechatMarketingPartnershipApi marketingshipApi(String tenantId) {
        return new WechatMarketingPartnershipApi(this.wechatPayClient, tenantId);
    }

    public WechatMarketingPayGiftActivityApi marketingPayGiftActivityApi(String tenantId) {
        return new WechatMarketingPayGiftActivityApi(this.wechatPayClient, tenantId);
    }

    public WechatBatchTransferApi batchTransferApi(String tenantId) {
        return new WechatBatchTransferApi(this.wechatPayClient, tenantId);
    }

    public WechatPayCallback callback(String tenantId) {
        return new WechatPayCallback(this.wechatPayClient.signatureProvider(), tenantId);
    }

    public WechatPayRedpackApi redpackApi(String tenantId) {
        WechatMetaBean wechatMeta = this.wechatPayClient.signatureProvider().wechatMetaContainer().getWechatMeta(tenantId);
        WechatV2Client wechatV2Client = new WechatV2Client(wechatMeta);
        return new WechatPayRedpackApi(wechatV2Client);
    }

    public WechatPayTransfersApi transfersApi(String tenantId) {
        WechatMetaBean wechatMeta = this.wechatPayClient.signatureProvider().wechatMetaContainer().getWechatMeta(tenantId);
        WechatV2Client wechatV2Client = new WechatV2Client(wechatMeta);
        return new WechatPayTransfersApi(wechatV2Client);
    }

    public WechatProfitsharingApi profitsharingApi(String tenantId) {
        return new WechatProfitsharingApi(this.wechatPayClient, tenantId);
    }

    public WechatPartnerProfitsharingApi partnerProfitsharingApi(String tenantId) {
        return new WechatPartnerProfitsharingApi(this.wechatPayClient, tenantId);
    }

    public WechatBrandProfitsharingApi brandProfitsharingApi(String tenantId) {
        return new WechatBrandProfitsharingApi(this.wechatPayClient, tenantId);
    }

    public WechatPartnerSpecialMchApi partnerSpecialMchApi(String tenantId) {
        return new WechatPartnerSpecialMchApi(this.wechatPayClient, tenantId);
    }

    public WechatSmartGuideApi smartGuideApi(String tenantId) {
        return new WechatSmartGuideApi(this.wechatPayClient, tenantId);
    }

    public WechatGoldPlanApi goldPlanApi(String tenantId) {
        return new WechatGoldPlanApi(this.wechatPayClient, tenantId);
    }

    public WechatEcommerceApi ecommerceApi(String tenantId) {
        return new WechatEcommerceApi(this.wechatPayClient, tenantId);
    }

    public WechatPartnerBusinessCircleApi partnerBusinessCircleApi(String tenantId) {
        return new WechatPartnerBusinessCircleApi(this.wechatPayClient, tenantId);
    }

    public WechatBusinessCircleApi businessCircleApi(String tenantId) {
        return new WechatBusinessCircleApi(this.wechatPayClient, tenantId);
    }

    public WechatMediaApi mediaApi(String tenantId) {
        return new WechatMediaApi(this.wechatPayClient, tenantId);
    }

    public WechatCapitalApi capitalApi(String tenantId) {
        return new WechatCapitalApi(this.wechatPayClient, tenantId);
    }

    public WechatComplaintsApi complaintsApi(String tenantId) {
        return new WechatComplaintsApi(this.wechatPayClient, tenantId);
    }
}

