/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.FundFlowAccountType;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.batchtransfer.CreateBatchTransferParams;
import cn.felord.payment.wechat.v3.model.batchtransfer.QueryBatchTransferDetailParams;
import cn.felord.payment.wechat.v3.model.batchtransfer.QueryBatchTransferParams;
import cn.felord.payment.wechat.v3.model.batchtransfer.QueryDayBalanceParams;
import cn.felord.payment.wechat.v3.model.batchtransfer.QueryIncomeRecordParams;
import cn.felord.payment.wechat.v3.model.batchtransfer.TransferDetailElectronicParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatBatchTransferApi
extends AbstractApi {
    public WechatBatchTransferApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> batchTransfer(CreateBatchTransferParams createBatchTransferParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_REQ, createBatchTransferParams).function(this::batchTransferFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> batchTransferFunction(WechatPayV3Type type, CreateBatchTransferParams createBatchTransferParams) {
        List<CreateBatchTransferParams.TransferDetailListItem> transferDetailList = createBatchTransferParams.getTransferDetailList();
        SignatureProvider signatureProvider = this.client().signatureProvider();
        X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
        X509Certificate x509Certificate = certificate.getX509Certificate();
        List<CreateBatchTransferParams.TransferDetailListItem> encrypted = transferDetailList.stream().peek(transferDetailListItem -> {
            String userIdCard;
            String userName = transferDetailListItem.getUserName();
            if (StringUtils.hasText((String)userName)) {
                String encryptedUserName = signatureProvider.encryptRequestMessage(userName, x509Certificate);
                transferDetailListItem.setUserName(encryptedUserName);
            }
            if (StringUtils.hasText((String)(userIdCard = transferDetailListItem.getUserIdCard()))) {
                String encryptedUserIdCard = signatureProvider.encryptRequestMessage(userIdCard, x509Certificate);
                transferDetailListItem.setUserIdCard(encryptedUserIdCard);
            }
        }).collect(Collectors.toList());
        createBatchTransferParams.setTransferDetailList(encrypted);
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
        return this.Post(uri, createBatchTransferParams, httpHeaders);
    }

    public WechatResponseEntity<ObjectNode> queryBatchByBatchId(QueryBatchTransferParams queryBatchTransferParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_BATCH_ID, queryBatchTransferParams).function((type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"need_query_detail", (Object)params.getNeedQueryDetail().toString());
            queryParams.add((Object)"offset", (Object)params.getOffset().toString());
            queryParams.add((Object)"limit", (Object)params.getLimit().toString());
            queryParams.add((Object)"detail_status", (Object)params.getDetailStatus().name());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{params.getCode()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBatchByOutBatchNo(QueryBatchTransferParams queryBatchTransferParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_OUT_BATCH_NO, queryBatchTransferParams).function((type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"need_query_detail", (Object)params.getNeedQueryDetail().toString());
            queryParams.add((Object)"offset", (Object)params.getOffset().toString());
            queryParams.add((Object)"limit", (Object)params.getLimit().toString());
            queryParams.add((Object)"detail_status", (Object)params.getDetailStatus().name());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{params.getCode()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBatchDetailByWechat(QueryBatchTransferDetailParams queryBatchTransferDetailParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_DETAIL_WECHAT, queryBatchTransferDetailParams).function((type, params) -> {
            HashMap<String, String> pathParams = new HashMap<String, String>(2);
            pathParams.put("batch_id", params.getBatchIdOrOutBatchNo());
            pathParams.put("detail_id", params.getDetailIdOrOutDetailNo());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(pathParams).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBatchDetailByMch(QueryBatchTransferDetailParams queryBatchTransferDetailParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_DETAIL_MCH, queryBatchTransferDetailParams).function((type, params) -> {
            HashMap<String, String> pathParams = new HashMap<String, String>(2);
            pathParams.put("out_batch_no", params.getBatchIdOrOutBatchNo());
            pathParams.put("out_detail_no", params.getDetailIdOrOutDetailNo());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(pathParams).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> receiptBill(String outBatchNo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_BILL_RECEIPT, outBatchNo).function((type, batchNo) -> {
            HashMap<String, String> body = new HashMap<String, String>(1);
            body.put("out_batch_no", outBatchNo);
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, body);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public ResponseEntity<Resource> downloadBill(String outBatchNo) {
        WechatResponseEntity wechatResponseEntity = new WechatResponseEntity();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_DOWNLOAD_BILL, outBatchNo).function((type, batchNo) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{batchNo}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        String downloadUrl = ((ObjectNode)wechatResponseEntity.getBody()).get("download_url").asText();
        Assert.hasText((String)downloadUrl, (String)"download url has no text");
        return this.billResource(downloadUrl);
    }

    public WechatResponseEntity<ObjectNode> transferElectronic(TransferDetailElectronicParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_ELECTRONIC, params).function((type, transferDetailElectronic) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, transferDetailElectronic);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryTransferElectronicResult(TransferDetailElectronicParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_ELECTRONIC_DETAIL, params).function((type, transferDetailElectronic) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"accept_type", (Object)transferDetailElectronic.getAcceptType().name());
            queryParams.add((Object)"out_batch_no", (Object)transferDetailElectronic.getOutBatchNo());
            queryParams.add((Object)"out_detail_no", (Object)transferDetailElectronic.getOutDetailNo());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryFundBalance(FundFlowAccountType accountType) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_FUND_BALANCE, accountType).function((type, flowAccountType) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{flowAccountType.name()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryDayFundBalance(QueryDayBalanceParams queryDayBalanceParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_FUND_DAY_BALANCE, queryDayBalanceParams).function((type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("date", new Object[]{params.getDate().toString()}).build().expand(new Object[]{params.getAccountType().name()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryIncomeRecords(QueryIncomeRecordParams queryIncomeRecordParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.BATCH_TRANSFER_FUND_INCOME_RECORDS, queryIncomeRecordParams).function((type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"account_type", (Object)params.getAccountType().name());
            queryParams.add((Object)"date", (Object)params.getDate().toString());
            queryParams.add((Object)"offset", (Object)Optional.ofNullable(params.getOffset()).orElse(0).toString());
            queryParams.add((Object)"limit", (Object)params.getLimit().toString());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

