/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.BranchBanksPageParams;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.PageParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatCapitalApi
extends AbstractApi {
    public WechatCapitalApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> searchBanksByBankAccount(String accountNumber) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.CAPITAL_SEARCH, accountNumber).function((type, param) -> {
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("account_number", new Object[]{signatureProvider.encryptRequestMessage((String)param, x509Certificate)}).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryPersonalBanks(PageParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.CAPITAL_PERSONAL, params).function((type, pageParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("offset", new Object[]{pageParams.getOffset()}).queryParam("limit", new Object[]{pageParams.getLimit()}).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryCorporateBanks(PageParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.CAPITAL_CORPORATE, params).function((type, pageParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("offset", new Object[]{pageParams.getOffset()}).queryParam("limit", new Object[]{pageParams.getLimit()}).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryProvinces() {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.CAPITAL_PROVINCES, "").function((type, pageParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryCitiesByProvince(Integer provinceCode) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.CAPITAL_CITIES, provinceCode).function((type, code) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{code}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBranchBanks(BranchBanksPageParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.CAPITAL_BRANCHES, params).function((type, pageParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("city_code", new Object[]{pageParams.getCityCode()}).queryParam("offset", new Object[]{pageParams.getOffset()}).queryParam("limit", new Object[]{pageParams.getLimit()}).build().expand(new Object[]{pageParams.getBankAliasCode()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

