/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.discountcard.DiscountCardPreRequestParams;
import cn.felord.payment.wechat.v3.model.discountcard.UserRecordsParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatDiscountCardApi
extends AbstractApi {
    public WechatDiscountCardApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> preRequest(DiscountCardPreRequestParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.DISCOUNT_CARD_PRE_REQUEST, params).function((wechatPayV3Type, requestParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            requestParams.setAppid(v3.getAppId());
            requestParams.setNotifyUrl(v3.getDomain().concat(requestParams.getNotifyUrl()));
            return this.Post(uri, requestParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> addUserRecords(UserRecordsParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.DISCOUNT_CARD_ADD_USER_RECORDS, params).function((wechatPayV3Type, recordsParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{recordsParams.getOutCardCode()}).toUri();
            recordsParams.setOutCardCode(null);
            return this.Post(uri, recordsParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> addUserRecords(String outCardCode) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.DISCOUNT_CARD_INFO, outCardCode).function((wechatPayV3Type, cardCode) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{cardCode}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

