/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.goldplan.GoldPlanAdvertisingParams;
import cn.felord.payment.wechat.v3.model.goldplan.GoldPlanChangeParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.Collections;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatGoldPlanApi
extends AbstractApi {
    public WechatGoldPlanApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> change(GoldPlanChangeParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.GOLD_PLAN_CHANGE, params).function((wechatPayV3Type, goldPlanChangeParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, goldPlanChangeParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> changeCustom(GoldPlanChangeParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.GOLD_PLAN_CHANGE_CUSTOM, params).function((wechatPayV3Type, goldPlanChangeParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, goldPlanChangeParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> filter(GoldPlanAdvertisingParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.GOLD_PLAN_CHANGE_CUSTOM, params).function((wechatPayV3Type, goldPlanChangeParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, goldPlanChangeParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> openAdv(GoldPlanAdvertisingParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.GOLD_PLAN_ADV_OPEN, params).function((wechatPayV3Type, goldPlanChangeParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, goldPlanChangeParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> closeAdv(String subMchid) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.GOLD_PLAN_ADV_CLOSE, subMchid).function((wechatPayV3Type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, Collections.singletonMap("sub_mchid", id));
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

