/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.StockStatus;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.CouponDetailsQueryParams;
import cn.felord.payment.wechat.v3.model.CouponsCardSendParams;
import cn.felord.payment.wechat.v3.model.MchQueryParams;
import cn.felord.payment.wechat.v3.model.StocksCreateParams;
import cn.felord.payment.wechat.v3.model.StocksQueryParams;
import cn.felord.payment.wechat.v3.model.StocksSendParams;
import cn.felord.payment.wechat.v3.model.UserCouponsQueryParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatMarketingFavorApi
extends AbstractApi {
    public WechatMarketingFavorApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> createStock(StocksCreateParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_COUPON_STOCKS, params).function(this::createStocksFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> createStocksFunction(WechatPayV3Type type, StocksCreateParams params) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        if (!StringUtils.hasText((String)params.getBelongMerchant())) {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            String mchId = v3.getMchId();
            params.setBelongMerchant(mchId);
        }
        return this.Post(uri, params);
    }

    public WechatResponseEntity<ObjectNode> startStock(String stockId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_START, stockId).function(this::startAndRestartAndPauseStockFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> sendStock(StocksSendParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_USERS_COUPONS, params).function(this::sendStocksFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> sendStocksFunction(WechatPayV3Type type, StocksSendParams params) {
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        params.setAppid(v3.getAppId());
        if (StringUtils.hasText((String)params.getStockCreatorMchid())) {
            params.setStockCreatorMchid(v3.getMchId());
        }
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{params.getOpenid()}).toUri();
        params.setOpenid(null);
        return this.Post(uri, params);
    }

    public WechatResponseEntity<ObjectNode> pauseStock(String stockId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_PAUSE, stockId).function(this::startAndRestartAndPauseStockFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> restartStock(String stockId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_RESTART, stockId).function(this::startAndRestartAndPauseStockFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> startAndRestartAndPauseStockFunction(WechatPayV3Type type, String stockId) {
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        String mchId = v3.getMchId();
        HashMap<String, String> body = new HashMap<String, String>(1);
        body.put("stock_creator_mchid", mchId);
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{stockId}).toUri();
        return this.Post(uri, body);
    }

    public WechatResponseEntity<ObjectNode> queryStocksByMch(StocksQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS, params).function(this::queryStocksByMchFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> queryStocksByMchFunction(WechatPayV3Type type, StocksQueryParams params) {
        StockStatus status;
        OffsetDateTime createEndTime;
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.add((Object)"offset", (Object)String.valueOf(params.getOffset()));
        queryParams.add((Object)"limit", (Object)String.valueOf(params.getLimit()));
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        queryParams.add((Object)"stock_creator_mchid", (Object)v3.getMchId());
        OffsetDateTime createStartTime = params.getCreateStartTime();
        if (Objects.nonNull(createStartTime)) {
            queryParams.add((Object)"create_start_time", (Object)createStartTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (Objects.nonNull(createEndTime = params.getCreateEndTime())) {
            queryParams.add((Object)"create_end_time", (Object)createEndTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (Objects.nonNull((Object)(status = params.getStatus()))) {
            queryParams.add((Object)"status", (Object)status.value());
        }
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
        return this.Get(uri);
    }

    public WechatResponseEntity<ObjectNode> queryStockDetail(String stockId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_DETAIL, stockId).function(this::stockDetailFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> stockDetailFunction(WechatPayV3Type type, String stockId) {
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.add((Object)"stock_creator_mchid", (Object)v3.getMchId());
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{stockId}).toUri();
        return this.Get(uri);
    }

    public WechatResponseEntity<ObjectNode> queryCouponDetails(CouponDetailsQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_USERS_COUPONS_DETAIL, params).function(this::couponDetailFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> couponDetailFunction(WechatPayV3Type type, CouponDetailsQueryParams params) {
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.add((Object)"appid", (Object)v3.getAppId());
        HashMap<String, String> pathParams = new HashMap<String, String>(2);
        pathParams.put("openid", params.getOpenId());
        pathParams.put("coupon_id", params.getCouponId());
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(pathParams).toUri();
        return this.Get(uri);
    }

    public WechatResponseEntity<ObjectNode> queryMerchantsByStockId(MchQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_MERCHANTS, params).function(this::queryMerchantsByStockIdFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> queryMerchantsByStockIdFunction(WechatPayV3Type type, MchQueryParams params) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.add((Object)"offset", (Object)String.valueOf(params.getOffset()));
        queryParams.add((Object)"limit", (Object)String.valueOf(params.getLimit()));
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        queryParams.add((Object)"stock_creator_mchid", (Object)v3.getMchId());
        String stockId = params.getStockId();
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{stockId}).toUri();
        return this.Get(uri);
    }

    public WechatResponseEntity<ObjectNode> queryStockItems(MchQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_ITEMS, params).function(this::queryMerchantsByStockIdFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryUserCouponsByMchId(UserCouponsQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_USERS_COUPONS, params).function(this::queryUserCouponsFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> queryUserCouponsFunction(WechatPayV3Type type, UserCouponsQueryParams params) {
        String availableMchId;
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.add((Object)"appid", (Object)v3.getAppId());
        queryParams.add((Object)"creator_mchid", (Object)v3.getMchId());
        String senderMchId = params.getSenderMchId();
        if (StringUtils.hasText((String)senderMchId)) {
            queryParams.add((Object)"sender_mchid", (Object)senderMchId);
        }
        if (StringUtils.hasText((String)(availableMchId = params.getAvailableMchId()))) {
            queryParams.add((Object)"available_mchid", (Object)availableMchId);
        } else {
            String offset = Objects.isNull(params.getOffset()) ? null : params.getOffset().toString();
            queryParams.add((Object)"offset", (Object)offset);
            String limit = Objects.isNull(params.getLimit()) ? null : params.getLimit().toString();
            queryParams.add((Object)"limit", (Object)limit);
            String status = Objects.nonNull((Object)params.getStatus()) ? params.getStatus().name() : null;
            queryParams.add((Object)"status", (Object)status);
            String stockId = params.getStockId();
            if (StringUtils.hasText((String)stockId)) {
                queryParams.add((Object)"stock_id", (Object)stockId);
            }
        }
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{params.getOpenId()}).toUri();
        return this.Get(uri);
    }

    public WechatResponseEntity<ObjectNode> downloadStockUseFlow(String stockId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_USE_FLOW, stockId).function(this::downloadFlowFunction).consumer(wechatResponseEntity::convert).request();
        String csv = this.billCsvDownload(((ObjectNode)wechatResponseEntity.getBody()).get("url").asText());
        ((ObjectNode)wechatResponseEntity.getBody()).put("csv", csv);
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> downloadStockRefundFlow(String stockId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_STOCKS_REFUND_FLOW, stockId).function(this::downloadFlowFunction).consumer(wechatResponseEntity::convert).request();
        String csv = this.billCsvDownload(((ObjectNode)wechatResponseEntity.getBody()).get("url").asText());
        ((ObjectNode)wechatResponseEntity.getBody()).put("csv", csv);
        return wechatResponseEntity;
    }

    private RequestEntity<?> downloadFlowFunction(WechatPayV3Type type, String stockId) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{stockId}).toUri();
        return this.Get(uri);
    }

    @Deprecated
    public WechatResponseEntity<ObjectNode> marketingImageUpload(MultipartFile file) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_IMAGE_UPLOAD, file).function(this::marketingImageUploadFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> marketingImageUploadFunction(WechatPayV3Type type, MultipartFile file) {
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>(2);
        String originalFilename = file.getOriginalFilename();
        String filename = StringUtils.hasText((String)originalFilename) ? originalFilename : file.getName();
        meta.put("filename", filename);
        byte[] digest = SHA256.Digest.getInstance((String)"SHA-256").digest(file.getBytes());
        meta.put("sha256", Hex.toHexString((byte[])digest));
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"meta", meta);
        body.add((Object)"file", (Object)file.getResource());
        String metaStr = this.getMapper().writeValueAsString(meta);
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        return ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)uri).header("Content-Type", new String[]{"multipart/form-data"})).header("Meta-Info", new String[]{metaStr})).header("Pay-TenantId", new String[]{this.tenantId()})).body((Object)body);
    }

    public WechatResponseEntity<ObjectNode> setMarketingFavorCallback(String notifyUrl) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_CALLBACKS, notifyUrl).function(this::setMarketingFavorCallbackFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> setMarketingFavorCallbackFunction(WechatPayV3Type type, String notifyUrl) {
        WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
        HashMap<String, Object> body = new HashMap<String, Object>(3);
        body.put("mchid", v3.getMchId());
        body.put("notify_url", notifyUrl);
        body.put("switch", true);
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        return this.Post(uri, body);
    }

    public WechatResponseEntity<ObjectNode> sendCouponsCard(CouponsCardSendParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_FAVOR_COUPONS_SEND, params).function((type, sendParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{sendParams.getCardId()}).toUri();
            sendParams.setCardId(null);
            if (!StringUtils.hasText((String)sendParams.getAppid())) {
                WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
                sendParams.setAppid(v3.getAppId());
            }
            return this.Post(uri, sendParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

