/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.partnership.Partner;
import cn.felord.payment.wechat.v3.model.partnership.PartnershipParams;
import cn.felord.payment.wechat.v3.model.partnership.PartnershipQueryParams;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class WechatMarketingPartnershipApi
extends AbstractApi {
    public WechatMarketingPartnershipApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> build(PartnershipParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PARTNERSHIPS_BUILD, params).function((type, partnershipParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            String idempotencyKey = partnershipParams.getIdempotencyKey();
            partnershipParams.clearKey();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Idempotency-Key", idempotencyKey);
            return this.Post(uri, partnershipParams, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> query(PartnershipQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PARTNERSHIPS_GET, params).function((type, partnershipParams) -> {
            Integer offset;
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            Partner partner = params.getPartner();
            try {
                ObjectMapper mapper = this.getMapper();
                if (Objects.nonNull(partner)) {
                    String partnerJson = mapper.writeValueAsString((Object)partner);
                    queryParams.add((Object)"partner", (Object)UriUtils.encode((String)partnerJson, (Charset)StandardCharsets.UTF_8));
                }
                String authorizedDataJson = mapper.writeValueAsString((Object)params.getAuthorizedData());
                queryParams.add((Object)"authorized_data", (Object)UriUtils.encode((String)authorizedDataJson, (Charset)StandardCharsets.UTF_8));
            }
            catch (JsonProcessingException e) {
                throw new PayException(e);
            }
            Integer limit = params.getLimit();
            if (Objects.nonNull(limit)) {
                queryParams.add((Object)"limit", (Object)limit.toString());
            }
            if (Objects.nonNull(offset = params.getOffset())) {
                queryParams.add((Object)"offset", (Object)offset.toString());
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build(false).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

