/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.paygiftactivity.ActivitiesListPageRequest;
import cn.felord.payment.wechat.v3.model.paygiftactivity.ActivitiesPageRequest;
import cn.felord.payment.wechat.v3.model.paygiftactivity.DeleteActivityMchRequest;
import cn.felord.payment.wechat.v3.model.paygiftactivity.GiftActivityParams;
import cn.felord.payment.wechat.v3.model.paygiftactivity.NewActivityMchRequest;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatMarketingPayGiftActivityApi
extends AbstractApi {
    public WechatMarketingPayGiftActivityApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> create(GiftActivityParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PAYGIFTACTIVITY, params).function((type, activityParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, activityParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> details(String activityId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PAYGIFTACTIVITY_DETAIL, activityId).function((type, param) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{param}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> merchants(ActivitiesPageRequest request) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PAYGIFTACTIVITY_MCH, request).function((type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("offset", new Object[]{params.getOffset()}).queryParam("limit", new Object[]{params.getLimit()}).build().expand(new Object[]{params.getActivityId()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> goods(ActivitiesPageRequest request) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PAYGIFTACTIVITY_GOODS, request).function((type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("offset", new Object[]{params.getOffset()}).queryParam("limit", new Object[]{params.getLimit()}).build().expand(new Object[]{params.getActivityId()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> terminate(String activityId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PAYGIFTACTIVITY_TERMINATE, activityId).function((type, param) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{param}).toUri();
            return this.Post(uri, Collections.emptyMap());
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> addMches(NewActivityMchRequest request) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PAYGIFTACTIVITY_MCH_ADD, request).function((type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{params.getActivityId()}).toUri();
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("merchant_id_list", params.getMerchantIdList());
            body.put("add_request_no", params.getAddRequestNo());
            return this.Post(uri, body);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> page(ActivitiesListPageRequest request) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PAYGIFTACTIVITY_ACTIVITIES, request).function((type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("offset", new Object[]{params.getOffset()}).queryParam("limit", new Object[]{params.getLimit()}).queryParam("activity_name", new Object[]{params.getActivityName()}).queryParam("activity_status", new Object[]{params.getActivityStatus()}).queryParam("award_type", new Object[]{params.getAwardType()}).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> deleteMch(DeleteActivityMchRequest request) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_PAYGIFTACTIVITY_MCH_DEL, request).function((type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{params.getActivityId()}).toUri();
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("merchant_id_list", params.getMerchantIdList());
            body.put("delete_request_no", params.getDeleteRequestNo());
            return this.Post(uri, body);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

