/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.LinkedHashMap;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatMediaApi
extends AbstractApi {
    public WechatMediaApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> mediaImageUpload(MultipartFile file) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MERCHANT_MEDIA_IMG, file).function(this::uploadFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> mediaVideoUpload(MultipartFile file) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MERCHANT_MEDIA_VIDEO, file).function(this::uploadFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private RequestEntity<?> uploadFunction(WechatPayV3Type type, MultipartFile file) {
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>(2);
        String originalFilename = file.getOriginalFilename();
        String filename = StringUtils.hasText((String)originalFilename) ? originalFilename : file.getName();
        meta.put("filename", filename);
        byte[] digest = SHA256.Digest.getInstance((String)"SHA-256").digest(file.getBytes());
        meta.put("sha256", Hex.toHexString((byte[])digest));
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"meta", meta);
        body.add((Object)"file", (Object)file.getResource());
        String metaStr = this.getMapper().writeValueAsString(meta);
        URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
        return ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)uri).header("Content-Type", new String[]{"multipart/form-data"})).header("Meta-Info", new String[]{metaStr})).header("Pay-TenantId", new String[]{this.tenantId()})).body((Object)body);
    }

    public WechatResponseEntity<ObjectNode> marketingImageUpload(MultipartFile file) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MARKETING_IMAGE_UPLOAD, file).function(this::uploadFunction).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

