/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.WechatTenantService;
import cn.felord.payment.wechat.v3.WechatMetaBean;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class WechatMetaContainer {
    private final Map<String, WechatMetaBean> wechatMetaBeanMap = new ConcurrentHashMap<String, WechatMetaBean>();
    private final WechatTenantService wechatTenantService;

    public void addWechatMetas(Collection<WechatMetaBean> wechatMetaBeans) {
        wechatMetaBeans.forEach(this::addMeta);
    }

    private void addMeta(WechatMetaBean wechatMetaBean) {
        String tenantId = wechatMetaBean.getTenantId();
        this.wechatMetaBeanMap.put(tenantId, wechatMetaBean);
    }

    public WechatMetaBean getWechatMeta(String tenantId) {
        WechatMetaBean wechatMetaBean = this.wechatMetaBeanMap.get(tenantId);
        if (Objects.nonNull(wechatMetaBean)) {
            return wechatMetaBean;
        }
        this.addWechatMetas(this.wechatTenantService.loadTenants());
        return Objects.requireNonNull(this.wechatMetaBeanMap.get(tenantId), "cant obtain the config with tenant: " + tenantId);
    }

    public Set<String> getTenantIds() {
        return this.wechatTenantService.loadTenants().stream().map(WechatMetaBean::getTenantId).collect(Collectors.toSet());
    }

    public WechatMetaContainer(WechatTenantService wechatTenantService) {
        this.wechatTenantService = wechatTenantService;
    }
}

