/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.busicircle.PartnerMallScoreParams;
import cn.felord.payment.wechat.v3.model.busicircle.PartnerMallScoreSyncRequest;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatPartnerBusinessCircleApi
extends AbstractApi {
    public WechatPartnerBusinessCircleApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> apply(PartnerMallScoreSyncRequest request) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MALL_SCORE_SYNC, request).function((wechatPayV3Type, mallScoreSyncRequest) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, mallScoreSyncRequest);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryAuthStatus(PartnerMallScoreParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.MALL_SCORE_RESULT, params).function((type, mallScoreParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("sub_mchid", new Object[]{mallScoreParams.getSubMchid()}).queryParam("appid", new Object[]{mallScoreParams.getAppid()}).build().expand(new Object[]{mallScoreParams.getOpenid()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

