/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.specmch.ApplymentParams;
import cn.felord.payment.wechat.v3.model.specmch.BankAccountInfo;
import cn.felord.payment.wechat.v3.model.specmch.ContactInfo;
import cn.felord.payment.wechat.v3.model.specmch.IdCardInfo;
import cn.felord.payment.wechat.v3.model.specmch.IdDocInfo;
import cn.felord.payment.wechat.v3.model.specmch.IdentityInfo;
import cn.felord.payment.wechat.v3.model.specmch.SubMchModifyParams;
import cn.felord.payment.wechat.v3.model.specmch.SubjectInfo;
import cn.felord.payment.wechat.v3.model.specmch.UboInfoListItem;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatPartnerSpecialMchApi
extends AbstractApi {
    public WechatPartnerSpecialMchApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> apply(ApplymentParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SPEC_MCH_APPLY_PARTNER, params).function((wechatPayV3Type, applymentParams) -> {
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            ApplymentParams applyRequestParams = this.convert((ApplymentParams)applymentParams, signatureProvider, x509Certificate);
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, applyRequestParams, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryByBusinessCode(String businessCode) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SPEC_MCH_APPLY_QUERY_BUSINESS_CODE, businessCode).function((type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryByApplymentId(String applymentId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SPEC_MCH_APPLY_QUERY_APPLYMENT_ID, applymentId).function((type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> modify(SubMchModifyParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SPEC_MCH_SUB_MODIFY, params).function((type, subMchModifyParams) -> {
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{subMchModifyParams.getSubMchid()}).toUri();
            subMchModifyParams.setSubMchid(null);
            subMchModifyParams.setAccountNumber(signatureProvider.encryptRequestMessage(subMchModifyParams.getAccountNumber(), x509Certificate));
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, subMchModifyParams, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> querySettlement(String subMchid) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SPEC_MCH_SUB_SETTLEMENT, subMchid).function((type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private ApplymentParams convert(ApplymentParams applymentParams, SignatureProvider signatureProvider, X509Certificate x509Certificate) {
        List<UboInfoListItem> uboInfoList;
        IdDocInfo idDocInfo;
        String openid;
        ContactInfo contactInfo = applymentParams.getContactInfo();
        contactInfo.setContactName(signatureProvider.encryptRequestMessage(contactInfo.getContactName(), x509Certificate));
        String contactIdNumber = contactInfo.getContactIdNumber();
        if (contactIdNumber != null) {
            contactInfo.setContactIdNumber(signatureProvider.encryptRequestMessage(contactIdNumber, x509Certificate));
        }
        if ((openid = contactInfo.getOpenid()) != null) {
            contactInfo.setOpenid(signatureProvider.encryptRequestMessage(openid, x509Certificate));
        }
        contactInfo.setMobilePhone(signatureProvider.encryptRequestMessage(contactInfo.getMobilePhone(), x509Certificate));
        contactInfo.setContactEmail(signatureProvider.encryptRequestMessage(contactInfo.getContactEmail(), x509Certificate));
        SubjectInfo subjectInfo = applymentParams.getSubjectInfo();
        IdentityInfo identityInfo = subjectInfo.getIdentityInfo();
        IdCardInfo idCardInfo = identityInfo.getIdCardInfo();
        if (idCardInfo != null) {
            idCardInfo.setIdCardName(signatureProvider.encryptRequestMessage(idCardInfo.getIdCardName(), x509Certificate));
            idCardInfo.setIdCardNumber(signatureProvider.encryptRequestMessage(idCardInfo.getIdCardNumber(), x509Certificate));
            String idCardAddress = idCardInfo.getIdCardAddress();
            if (StringUtils.hasText((String)idCardAddress)) {
                idCardInfo.setIdCardAddress(signatureProvider.encryptRequestMessage(idCardAddress, x509Certificate));
            }
        }
        if ((idDocInfo = identityInfo.getIdDocInfo()) != null) {
            idDocInfo.setIdDocName(signatureProvider.encryptRequestMessage(idDocInfo.getIdDocName(), x509Certificate));
            idDocInfo.setIdDocNumber(signatureProvider.encryptRequestMessage(idDocInfo.getIdDocNumber(), x509Certificate));
            String idDocAddress = idDocInfo.getIdDocAddress();
            if (StringUtils.hasText((String)idDocAddress)) {
                idDocInfo.setIdDocAddress(signatureProvider.encryptRequestMessage(idDocAddress, x509Certificate));
            }
        }
        if (!CollectionUtils.isEmpty(uboInfoList = subjectInfo.getUboInfoList())) {
            uboInfoList.forEach(uboInfoListItem -> {
                uboInfoListItem.setUboIdDocName(signatureProvider.encryptRequestMessage(uboInfoListItem.getUboIdDocName(), x509Certificate));
                uboInfoListItem.setUboIdDocNumber(signatureProvider.encryptRequestMessage(uboInfoListItem.getUboIdDocNumber(), x509Certificate));
                uboInfoListItem.setUboIdDocAddress(signatureProvider.encryptRequestMessage(uboInfoListItem.getUboIdDocAddress(), x509Certificate));
            });
        }
        BankAccountInfo bankAccountInfo = applymentParams.getBankAccountInfo();
        bankAccountInfo.setAccountName(signatureProvider.encryptRequestMessage(bankAccountInfo.getAccountName(), x509Certificate));
        bankAccountInfo.setAccountNumber(signatureProvider.encryptRequestMessage(bankAccountInfo.getAccountNumber(), x509Certificate));
        return applymentParams;
    }
}

