/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.RefundParams;
import cn.felord.payment.wechat.v3.model.payscore.parking.ParkingParams;
import cn.felord.payment.wechat.v3.model.payscore.parking.ParkingServiceQueryParams;
import cn.felord.payment.wechat.v3.model.payscore.parking.TransParkingParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatPayScoreParkingApi
extends AbstractApi {
    public WechatPayScoreParkingApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> find(ParkingServiceQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PARKING_FIND, params).function((wechatPayV3Type, parkingServiceQueryParams) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"appid", (Object)parkingServiceQueryParams.getAppid());
            queryParams.add((Object)"plate_number", (Object)parkingServiceQueryParams.getPlateNumber());
            queryParams.add((Object)"plate_color", (Object)parkingServiceQueryParams.getPlateColor().name());
            queryParams.add((Object)"openid", (Object)parkingServiceQueryParams.getOpenid());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).encode().build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> parking(ParkingParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PARKING_PARKINGS, params).function((wechatPayV3Type, parkingParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            parkingParams.setNotifyUrl(v3.getDomain().concat(parkingParams.getNotifyUrl()));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, parkingParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> transactionsParking(TransParkingParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PARKING_TRANSACTIONS_PARKINGS, params).function((wechatPayV3Type, transParkingParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            transParkingParams.setNotifyUrl(v3.getDomain().concat(transParkingParams.getNotifyUrl()));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, transParkingParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryTransactionByOutTradeNo(String outTradeNo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PARKING_TRANSACTIONS_OUTTRADENO, outTradeNo).function((wechatPayV3Type, tradeNo) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{tradeNo}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> refund(RefundParams refundParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.REFUND, refundParams).function((type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            String notifyUrl = params.getNotifyUrl();
            if (StringUtils.hasText((String)notifyUrl)) {
                params.setNotifyUrl(v3.getDomain().concat(notifyUrl));
            }
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryRefundInfo(String outRefundNo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.QUERY_REFUND, outRefundNo).function((type, param) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{param}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

