/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.smartguide.PartnerAssignParams;
import cn.felord.payment.wechat.v3.model.smartguide.PartnerSmartGuidesParams;
import cn.felord.payment.wechat.v3.model.smartguide.PartnerSmartGuidesQueryParams;
import cn.felord.payment.wechat.v3.model.smartguide.SmartGuidesModifyParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatSmartGuideApi
extends AbstractApi {
    public WechatSmartGuideApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> register(PartnerSmartGuidesParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SMART_GUIDES, params).function((wechatPayV3Type, smartGuidesParams) -> {
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            smartGuidesParams.setName(signatureProvider.encryptRequestMessage(smartGuidesParams.getName(), x509Certificate));
            smartGuidesParams.setMobile(signatureProvider.encryptRequestMessage(smartGuidesParams.getMobile(), x509Certificate));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, smartGuidesParams, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> assign(PartnerAssignParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SMART_GUIDES_ASSIGN, params).function((wechatPayV3Type, assignParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{assignParams.getGuideId()}).toUri();
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("sub_mchid", assignParams.getSubMchid());
            map.put("out_trade_no", assignParams.getOutTradeNo());
            return this.Post(uri, map);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> query(PartnerSmartGuidesQueryParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SMART_GUIDES_GET, params).function((wechatPayV3Type, smartGuidesQueryParams) -> {
            Integer limit;
            Integer offset;
            String workId;
            String mobile;
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Pay-TenantId", this.tenantId());
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            String subMchid = smartGuidesQueryParams.getSubMchid();
            if (subMchid != null) {
                queryParams.add((Object)"sub_mchid", (Object)subMchid);
            }
            queryParams.add((Object)"store_id", (Object)String.valueOf(smartGuidesQueryParams.getStoreId()));
            String userid = smartGuidesQueryParams.getUserid();
            if (userid != null) {
                queryParams.add((Object)"userid", (Object)userid);
            }
            if ((mobile = smartGuidesQueryParams.getMobile()) != null) {
                SignatureProvider signatureProvider = this.client().signatureProvider();
                X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
                X509Certificate x509Certificate = certificate.getX509Certificate();
                queryParams.add((Object)"mobile", (Object)signatureProvider.encryptRequestMessage(mobile, x509Certificate));
                httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            }
            if ((workId = smartGuidesQueryParams.getWorkId()) != null) {
                queryParams.add((Object)"work_id", (Object)workId);
            }
            if ((offset = smartGuidesQueryParams.getOffset()) != null) {
                queryParams.add((Object)"offset", (Object)String.valueOf(offset));
            }
            if ((limit = smartGuidesQueryParams.getLimit()) != null) {
                queryParams.add((Object)"limit", (Object)String.valueOf(limit));
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return RequestEntity.get((URI)uri).headers(httpHeaders).build();
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> modify(SmartGuidesModifyParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.SMART_GUIDES_MODIFY, params).function((wechatPayV3Type, smartGuidesParams) -> {
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            smartGuidesParams.setName(signatureProvider.encryptRequestMessage(smartGuidesParams.getName(), x509Certificate));
            smartGuidesParams.setMobile(signatureProvider.encryptRequestMessage(smartGuidesParams.getMobile(), x509Certificate));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Patch(uri, smartGuidesParams, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

