/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.ecommerce;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPartnerSpecialMchApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceAccountInfo;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceApplymentParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceContactInfo;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceIdCardInfo;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceIdDocInfo;
import cn.felord.payment.wechat.v3.model.ecommerce.UboInfo;
import cn.felord.payment.wechat.v3.model.specmch.SubMchModifyParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class ApplymentApi
extends AbstractApi {
    private final WechatPartnerSpecialMchApi wechatPartnerSpecialMchApi;

    ApplymentApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
        this.wechatPartnerSpecialMchApi = new WechatPartnerSpecialMchApi(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> apply(EcommerceApplymentParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_APPLYMENT, params).function((wechatPayV3Type, applymentParams) -> {
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            EcommerceApplymentParams applyRequestParams = this.convert((EcommerceApplymentParams)applymentParams, signatureProvider, x509Certificate);
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, applyRequestParams, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryByApplymentId(String applymentId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_APPLYMENT_ID, applymentId).function((type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryByBusinessCode(String outRequestNo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_APPLYMENT_OUT_REQUEST_NO, outRequestNo).function((type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> modify(SubMchModifyParams params) {
        return this.wechatPartnerSpecialMchApi.modify(params);
    }

    public WechatResponseEntity<ObjectNode> querySettlement(String subMchid) {
        return this.wechatPartnerSpecialMchApi.querySettlement(subMchid);
    }

    private EcommerceApplymentParams convert(EcommerceApplymentParams applymentParams, SignatureProvider signatureProvider, X509Certificate x509Certificate) {
        EcommerceAccountInfo accountInfo;
        UboInfo uboInfo;
        EcommerceIdDocInfo idDocInfo;
        EcommerceIdCardInfo idCardInfo = applymentParams.getIdCardInfo();
        if (idCardInfo != null) {
            idCardInfo.setIdCardName(signatureProvider.encryptRequestMessage(idCardInfo.getIdCardName(), x509Certificate));
            idCardInfo.setIdCardNumber(signatureProvider.encryptRequestMessage(idCardInfo.getIdCardNumber(), x509Certificate));
            String idCardAddress = idCardInfo.getIdCardAddress();
            if (StringUtils.hasText((String)idCardAddress)) {
                idCardInfo.setIdCardAddress(signatureProvider.encryptRequestMessage(idCardAddress, x509Certificate));
            }
        }
        if ((idDocInfo = applymentParams.getIdDocInfo()) != null) {
            idDocInfo.setIdDocName(signatureProvider.encryptRequestMessage(idDocInfo.getIdDocName(), x509Certificate));
            idDocInfo.setIdDocNumber(signatureProvider.encryptRequestMessage(idDocInfo.getIdDocNumber(), x509Certificate));
            String idDocAddress = idDocInfo.getIdDocAddress();
            if (StringUtils.hasText((String)idDocAddress)) {
                idDocInfo.setIdDocAddress(signatureProvider.encryptRequestMessage(idDocAddress, x509Certificate));
            }
        }
        if ((uboInfo = applymentParams.getUboInfo()) != null) {
            UboInfo.IdDocInfo docInfo;
            UboInfo.IdCardInfo cardInfo = uboInfo.getIdCardInfo();
            if (cardInfo != null) {
                cardInfo.setIdCardName(signatureProvider.encryptRequestMessage(cardInfo.getIdCardName(), x509Certificate));
                cardInfo.setIdCardNumber(signatureProvider.encryptRequestMessage(cardInfo.getIdCardNumber(), x509Certificate));
            }
            if ((docInfo = uboInfo.getIdDocInfo()) != null) {
                docInfo.setIdDocName(signatureProvider.encryptRequestMessage(docInfo.getIdDocName(), x509Certificate));
                docInfo.setIdDocNumber(signatureProvider.encryptRequestMessage(docInfo.getIdDocNumber(), x509Certificate));
            }
        }
        if ((accountInfo = applymentParams.getAccountInfo()) != null) {
            accountInfo.setAccountName(signatureProvider.encryptRequestMessage(accountInfo.getAccountName(), x509Certificate));
            accountInfo.setAccountNumber(signatureProvider.encryptRequestMessage(accountInfo.getAccountNumber(), x509Certificate));
        }
        EcommerceContactInfo contactInfo = applymentParams.getContactInfo();
        contactInfo.setContactName(signatureProvider.encryptRequestMessage(contactInfo.getContactName(), x509Certificate));
        contactInfo.setContactIdCardNumber(signatureProvider.encryptRequestMessage(contactInfo.getContactIdCardNumber(), x509Certificate));
        contactInfo.setMobilePhone(signatureProvider.encryptRequestMessage(contactInfo.getMobilePhone(), x509Certificate));
        String contactEmail = contactInfo.getContactEmail();
        if (contactEmail != null) {
            contactInfo.setContactEmail(signatureProvider.encryptRequestMessage(contactEmail, x509Certificate));
        }
        return applymentParams;
    }
}

