/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.ecommerce;

import cn.felord.payment.wechat.enumeration.FundFlowAccountType;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceFundEndDay;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceFundSubMch;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.time.format.DateTimeFormatter;
import org.springframework.web.util.UriComponentsBuilder;

public class BalanceApi
extends AbstractApi {
    BalanceApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> queryBySubMchid(EcommerceFundSubMch params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_BALANCE_REAL_TIME, params).function((type, fundSubMch) -> {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA));
            if (params.getAccountType() != null) {
                builder.queryParam("account_type", new Object[]{fundSubMch.getAccountType().name()});
            }
            URI uri = builder.build().expand(new Object[]{fundSubMch.getSubMchid()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryAtEndDay(EcommerceFundEndDay params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_BALANCE_END_DAY, params).function((type, fundEndDay) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("account_type", new Object[]{fundEndDay.getDate().format(DateTimeFormatter.ISO_DATE)}).build().expand(new Object[]{fundEndDay.getSubMchid()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBalanceAtRealTime(FundFlowAccountType type) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_BALANCE_TYPE_REAL_TIME, type).function((wechatPayV3Type, accountType) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{accountType.name()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryBalanceAtEndDay(FundFlowAccountType type) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_BALANCE_TYPE_END_DAY, type).function((wechatPayV3Type, accountType) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{accountType.name()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

