/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.ecommerce;

import cn.felord.payment.wechat.enumeration.FundFlowAccountType;
import cn.felord.payment.wechat.enumeration.TarType;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPartnerProfitsharingApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.FundFlowBillParams;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerProfitsharingBillParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class DownloadApi
extends AbstractApi {
    private final WechatPartnerProfitsharingApi wechatPartnerProfitsharingApi;

    DownloadApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
        this.wechatPartnerProfitsharingApi = new WechatPartnerProfitsharingApi(wechatPayClient, tenantId);
    }

    public ResponseEntity<Resource> downloadProfitsharingBills(PartnerProfitsharingBillParams params) {
        return this.wechatPartnerProfitsharingApi.downloadMerchantBills(params);
    }

    public WechatResponseEntity<ObjectNode> downloadMchFundFlowBill(FundFlowBillParams fundFlowBillParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_FLOW_BILL, fundFlowBillParams).function((wechatPayV3Type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            LocalDate billDate = params.getBillDate();
            queryParams.add((Object)"bill_date", (Object)billDate.format(DateTimeFormatter.ISO_DATE));
            FundFlowAccountType accountType = Optional.ofNullable(params.getAccountType()).orElse(FundFlowAccountType.BASIC);
            queryParams.add((Object)"account_type", (Object)accountType.name());
            TarType tarType = params.getTarType();
            if (Objects.nonNull((Object)tarType)) {
                queryParams.add((Object)"tar_type", (Object)tarType.name());
            }
            queryParams.add((Object)"algorithm", (Object)"AEAD_AES_256_GCM");
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

