/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.ecommerce;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceFundOverseaOrder;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceFundOverseaParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceFundOverseaResultParams;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerProfitsharingBillParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.UriComponentsBuilder;

public class FundOverseaApi
extends AbstractApi {
    FundOverseaApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> queryBalance(EcommerceFundOverseaParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_OVERSEA_BALANCE, params).function((type, fundOverseaParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("sub_mchid", new Object[]{fundOverseaParams.getSubMchid()}).build().expand(new Object[]{fundOverseaParams.getTransactionId()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> apply(EcommerceFundOverseaOrder order) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_OVERSEA_ORDERS, order).function((wechatPayV3Type, overseaOrder) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, overseaOrder);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryOrder(EcommerceFundOverseaResultParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_OVERSEA_ORDERS_RESULT, params).function((type, overseaResultParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("sub_mchid", new Object[]{overseaResultParams.getSubMchid()}).queryParam("transaction_id", new Object[]{overseaResultParams.getTransactionId()}).build().expand(new Object[]{overseaResultParams.getOutOrderId()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public ResponseEntity<Resource> downloadMerchantBills(PartnerProfitsharingBillParams billParams) {
        WechatResponseEntity wechatResponseEntity = new WechatResponseEntity();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_OVERSEA_BILLS, billParams).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParam("bill_date", new Object[]{params.getBillDate().format(DateTimeFormatter.ISO_DATE)}).queryParam("sub_mchid", new Object[]{params.getSubMchid()}).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        String downloadUrl = ((ObjectNode)Objects.requireNonNull(wechatResponseEntity.getBody())).get("download_url").asText();
        String ext = ".gzip";
        String filename = "fundoverseabill-" + billParams.getBillDate().toString() + ext;
        return this.downloadBillResponse(downloadUrl, filename);
    }
}

