/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.ecommerce;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.ReceiverType;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceFinishOrder;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceProfitsharingOrder;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceReceiver;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceReceiverDeleteParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceReturnOrderParams;
import cn.felord.payment.wechat.v3.model.ecommerce.Receiver;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerQueryOrderParams;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerReturnOrdersParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class ProfitsharingApi
extends AbstractApi {
    ProfitsharingApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> profitsharingOrders(EcommerceProfitsharingOrder profitSharingOrder) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_PROFITSHARING_ORDERS, profitSharingOrder).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            params.setAppid(v3.getAppId());
            List<Receiver> receivers = params.getReceivers();
            if (!CollectionUtils.isEmpty(receivers)) {
                receivers.forEach(receiversItem -> {
                    String name = receiversItem.getReceiverName();
                    if (StringUtils.hasText((String)name)) {
                        String encryptedName = signatureProvider.encryptRequestMessage(name, x509Certificate);
                        receiversItem.setReceiverName(encryptedName);
                    }
                });
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, params, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryProfitsharingOrder(PartnerQueryOrderParams queryOrderParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_PROFITSHARING_RESULT, queryOrderParams).function((wechatPayV3Type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"sub_mchid", (Object)params.getSubMchid());
            queryParams.add((Object)"transaction_id", (Object)params.getTransactionId());
            queryParams.add((Object)"out_order_no", (Object)params.getOutOrderNo());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> returnOrders(PartnerReturnOrdersParams returnOrdersParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_PROFITSHARING_RETURN_ORDERS, returnOrdersParams).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryReturnOrders(EcommerceReturnOrderParams queryReturnOrderParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_PROFITSHARING_RETURN_ORDERS_RESULT, queryReturnOrderParams).function((wechatPayV3Type, params) -> {
            String outOrderNo;
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"sub_mchid", (Object)params.getSubMchid());
            String orderId = params.getOrderId();
            if (orderId != null) {
                queryParams.add((Object)"order_id", (Object)orderId);
            }
            if ((outOrderNo = params.getOutOrderNo()) != null) {
                queryParams.add((Object)"out_order_no", (Object)outOrderNo);
            }
            queryParams.add((Object)"out_return_no", (Object)params.getOutReturnNo());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> finishOrder(EcommerceFinishOrder finishOrder) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_PROFITSHARING_FINISH_ORDER, finishOrder).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryOrderAmounts(String transactionId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_PROFITSHARING_ORDER_AMOUNTS, transactionId).function((wechatPayV3Type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> addReceivers(EcommerceReceiver ecommerceReceiver) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_PROFITSHARING_RECEIVERS_ADD, ecommerceReceiver).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            params.setAppid(v3.getAppId());
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            String name = params.getName();
            if (ReceiverType.PERSONAL_OPENID.equals((Object)params.getType()) && StringUtils.hasText((String)name)) {
                String encryptedName = signatureProvider.encryptRequestMessage(name, x509Certificate);
                params.setEncryptedName(encryptedName);
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, params, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> deleteReceivers(EcommerceReceiverDeleteParams delReceiversParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_PROFITSHARING_RECEIVERS_DELETE, delReceiversParams).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            params.setAppid(v3.getAppId());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

