/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.ecommerce;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceRefundParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceReturnAdvance;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.Collections;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class RefundsApi
extends AbstractApi {
    RefundsApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> apply(EcommerceRefundParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_REFUNDS_APPLY, params).function((wechatPayV3Type, refundParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            refundParams.setSpAppid(v3.getAppId());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, refundParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryByRefundId(String refundId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_REFUNDS_ID, refundId).function((type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryByOutRefundNo(String outRefundNo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_REFUNDS_OUT_REFUND_NO, outRefundNo).function((type, no) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{no}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> returnAdvance(EcommerceReturnAdvance params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_REFUNDS_RETURN_ADVANCE, params).function((wechatPayV3Type, advanceParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{advanceParams.getRefundId()}).toUri();
            return this.Post(uri, Collections.singletonMap("sub_mchid", advanceParams.getSubMchid()));
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryAdvanceResult(EcommerceReturnAdvance params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_REFUNDS_RETURN_ADVANCE_RESULT, params).function((type, returnAdvance) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"refund_id", (Object)returnAdvance.getRefundId());
            queryParams.add((Object)"sub_mchid", (Object)returnAdvance.getSubMchid());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

