/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.ecommerce;

import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceSubsidiesCancelParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceSubsidiesCreateParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceSubsidiesReturnParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.springframework.web.util.UriComponentsBuilder;

public class SubsidiesApi
extends AbstractApi {
    SubsidiesApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> create(EcommerceSubsidiesCreateParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_SUBSIDIES_CREATE, params).function((wechatPayV3Type, createParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, createParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> spreadBack(EcommerceSubsidiesReturnParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_SUBSIDIES_RETURN, params).function((wechatPayV3Type, returnParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, returnParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> cancel(EcommerceSubsidiesCancelParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_SUBSIDIES_CANCEL, params).function((wechatPayV3Type, returnParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, returnParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

