/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.ecommerce;

import cn.felord.payment.wechat.enumeration.TarType;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceErrorBillParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceMchReserveParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceOutRequestNo;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceReserveParams;
import cn.felord.payment.wechat.v3.model.ecommerce.EcommerceWithdraw;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class WithDrawApi
extends AbstractApi {
    WithDrawApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> ecommerceReserve(EcommerceReserveParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_WITHDRAW, params).function((wechatPayV3Type, refundParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, refundParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryByWithdrawId(EcommerceWithdraw params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_WITHDRAW_ID, params).function((type, ecommerceWithdraw) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("sub_mchid", new Object[]{ecommerceWithdraw.getSubMchid()}).build().expand(new Object[]{ecommerceWithdraw.getWithdrawId()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryByOutRequestNo(EcommerceOutRequestNo params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_WITHDRAW_OUT_REQUEST_NO, params).function((type, ecommerceWithdraw) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).queryParam("sub_mchid", new Object[]{ecommerceWithdraw.getSubMchid()}).build().expand(new Object[]{ecommerceWithdraw.getOutRequestNo()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> ecommerceMchReserve(EcommerceMchReserveParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_MERCHANT_WITHDRAW, params).function((wechatPayV3Type, refundParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, refundParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryMchByWithdrawId(String withdrawId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_MERCHANT_WITHDRAW_ID, withdrawId).function((type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{withdrawId}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryMchByOutRequestNo(String outRequestNo) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_WITHDRAW_MERCHANT_OUT_REQUEST_NO, outRequestNo).function((type, no) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)type.uri(WeChatServer.CHINA)).build().expand(new Object[]{no}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public ResponseEntity<Resource> downloadErrorBill(EcommerceErrorBillParams params) {
        WechatResponseEntity wechatResponseEntity = new WechatResponseEntity();
        this.client().withType(WechatPayV3Type.ECOMMERCE_FUND_WITHDRAW_ERROR_BILL, params).function((wechatPayV3Type, errorBillParams) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            LocalDate billDate = params.getBillDate();
            queryParams.add((Object)"bill_date", (Object)billDate.format(DateTimeFormatter.ISO_DATE));
            TarType tarType = params.getTarType();
            if (Objects.nonNull((Object)tarType)) {
                queryParams.add((Object)"tar_type", (Object)tarType.name());
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{"NO_SUCC"}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        String downloadUrl = ((ObjectNode)Objects.requireNonNull(wechatResponseEntity.getBody())).get("download_url").asText();
        String ext = Objects.equals((Object)TarType.GZIP, (Object)params.getTarType()) ? ".gzip" : ".txt";
        String filename = "errorbill-" + params.getBillDate().toString() + ext;
        return this.downloadBillResponse(downloadUrl, filename);
    }
}

