/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLJoinTableSource
extends SQLTableSourceImpl
implements SQLReplaceable {
    protected SQLTableSource left;
    protected JoinType joinType;
    protected SQLTableSource right;
    protected SQLExpr condition;
    protected final List<SQLExpr> using = new ArrayList<SQLExpr>();
    protected boolean natural = false;

    public SQLJoinTableSource(String alias) {
        super(alias);
    }

    public SQLJoinTableSource() {
    }

    public SQLJoinTableSource(SQLTableSource left, JoinType joinType, SQLTableSource right, SQLExpr condition) {
        this.setLeft(left);
        this.setJoinType(joinType);
        this.setRight(right);
        this.setCondition(condition);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.left);
            this.acceptChild(visitor, this.right);
            this.acceptChild(visitor, this.condition);
            this.acceptChild(visitor, this.using);
        }
        visitor.endVisit(this);
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public SQLTableSource getLeft() {
        return this.left;
    }

    public void setLeft(SQLTableSource left) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
    }

    public void setLeft(String tableName, String alias) {
        SQLExprTableSource tableSource = tableName == null || tableName.length() == 0 ? null : new SQLExprTableSource(new SQLIdentifierExpr(tableName), alias);
        this.setLeft(tableSource);
    }

    public void setRight(String tableName, String alias) {
        SQLExprTableSource tableSource = tableName == null || tableName.length() == 0 ? null : new SQLExprTableSource(new SQLIdentifierExpr(tableName), alias);
        this.setRight(tableSource);
    }

    public SQLTableSource getRight() {
        return this.right;
    }

    public void setRight(SQLTableSource right) {
        if (right != null) {
            right.setParent(this);
        }
        this.right = right;
    }

    public SQLExpr getCondition() {
        return this.condition;
    }

    public void setCondition(SQLExpr condition) {
        if (condition != null) {
            condition.setParent(this);
        }
        this.condition = condition;
    }

    public List<SQLExpr> getUsing() {
        return this.using;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
    }

    @Override
    public void output(StringBuffer buf) {
        this.left.output(buf);
        buf.append(' ');
        buf.append(JoinType.toString(this.joinType));
        buf.append(' ');
        this.right.output(buf);
        if (this.condition != null) {
            buf.append(" ON ");
            this.condition.output(buf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLJoinTableSource that = (SQLJoinTableSource)o;
        if (this.natural != that.natural) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.joinType != that.joinType) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return this.using != null ? this.using.equals(that.using) : that.using == null;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.condition == expr) {
            this.setCondition(target);
            return true;
        }
        return false;
    }

    public void cloneTo(SQLJoinTableSource x) {
        x.alias = this.alias;
        if (this.left != null) {
            x.setLeft(this.left.clone());
        }
        x.joinType = this.joinType;
        if (this.right != null) {
            x.setRight(this.right.clone());
        }
        for (SQLExpr item : this.using) {
            SQLExpr item2 = item.clone();
            item2.setParent(x);
            x.using.add(item2);
        }
        x.natural = this.natural;
    }

    @Override
    public SQLJoinTableSource clone() {
        SQLJoinTableSource x = new SQLJoinTableSource();
        this.cloneTo(x);
        return x;
    }

    public void reverse() {
        SQLTableSource temp = this.left;
        this.left = this.right;
        this.right = temp;
        if (this.left instanceof SQLJoinTableSource) {
            ((SQLJoinTableSource)this.left).reverse();
        }
        if (this.right instanceof SQLJoinTableSource) {
            ((SQLJoinTableSource)this.right).reverse();
        }
    }

    public void rearrangement() {
        if (this.right instanceof SQLJoinTableSource) {
            SQLJoinTableSource rightJoin = (SQLJoinTableSource)this.right;
            SQLTableSource a = this.left;
            SQLTableSource b = rightJoin.getLeft();
            SQLTableSource c = rightJoin.getRight();
            SQLExpr on_ab = this.condition;
            SQLExpr on_bc = rightJoin.condition;
            this.setLeft(rightJoin);
            rightJoin.setLeft(a);
            rightJoin.setRight(b);
            rightJoin.setCondition(on_ab);
            this.setRight(c);
            this.setCondition(on_bc);
        }
    }

    public static enum JoinType {
        COMMA(","),
        JOIN("JOIN"),
        INNER_JOIN("INNER JOIN"),
        CROSS_JOIN("CROSS JOIN"),
        NATURAL_JOIN("NATURAL JOIN"),
        NATURAL_INNER_JOIN("NATURAL INNER JOIN"),
        LEFT_OUTER_JOIN("LEFT JOIN"),
        LEFT_SEMI_JOIN("LEFT SEMI JOIN"),
        LEFT_ANTI_JOIN("LEFT ANTI JOIN"),
        RIGHT_OUTER_JOIN("RIGHT JOIN"),
        FULL_OUTER_JOIN("FULL JOIN"),
        STRAIGHT_JOIN("STRAIGHT_JOIN"),
        OUTER_APPLY("OUTER APPLY"),
        CROSS_APPLY("CROSS APPLY");

        public final String name;
        public final String name_lcase;

        private JoinType(String name) {
            this.name = name;
            this.name_lcase = name.toLowerCase();
        }

        public static String toString(JoinType joinType) {
            return joinType.name;
        }
    }
}

