/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.IcmpTypeCode;
import com.amazonaws.services.ec2.model.PortRange;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReplaceNetworkAclEntryRequestMarshaller
implements Marshaller<Request<ReplaceNetworkAclEntryRequest>, ReplaceNetworkAclEntryRequest> {
    public Request<ReplaceNetworkAclEntryRequest> marshall(ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest) {
        PortRange portRange;
        IcmpTypeCode icmpTypeCode;
        if (replaceNetworkAclEntryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceNetworkAclEntryRequest, "AmazonEC2");
        request.addParameter("Action", "ReplaceNetworkAclEntry");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceNetworkAclEntryRequest.getNetworkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getNetworkAclId()));
        }
        if (replaceNetworkAclEntryRequest.getRuleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger((Integer)replaceNetworkAclEntryRequest.getRuleNumber()));
        }
        if (replaceNetworkAclEntryRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getProtocol()));
        }
        if (replaceNetworkAclEntryRequest.getRuleAction() != null) {
            request.addParameter("RuleAction", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getRuleAction()));
        }
        if (replaceNetworkAclEntryRequest.getEgress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean((Boolean)replaceNetworkAclEntryRequest.getEgress()));
        }
        if (replaceNetworkAclEntryRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getCidrBlock()));
        }
        if (replaceNetworkAclEntryRequest.getIpv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getIpv6CidrBlock()));
        }
        if ((icmpTypeCode = replaceNetworkAclEntryRequest.getIcmpTypeCode()) != null) {
            if (icmpTypeCode.getType() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger((Integer)icmpTypeCode.getType()));
            }
            if (icmpTypeCode.getCode() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger((Integer)icmpTypeCode.getCode()));
            }
        }
        if ((portRange = replaceNetworkAclEntryRequest.getPortRange()) != null) {
            if (portRange.getFrom() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger((Integer)portRange.getFrom()));
            }
            if (portRange.getTo() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger((Integer)portRange.getTo()));
            }
        }
        return request;
    }
}

