/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidStatConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidWallConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class DruidConfig {
    private static final Logger log = LoggerFactory.getLogger(DruidConfig.class);
    private Integer initialSize;
    private Integer maxActive;
    private Integer minIdle;
    private Long maxWait;
    private Long timeBetweenEvictionRunsMillis;
    private Long timeBetweenLogStatsMillis;
    private Integer statSqlMaxSize;
    private Long minEvictableIdleTimeMillis;
    private Long maxEvictableIdleTimeMillis;
    private Boolean testWhileIdle;
    private Boolean testOnBorrow;
    private Boolean testOnReturn;
    private String validationQuery;
    private Integer validationQueryTimeout;
    private Boolean useGlobalDataSourceStat;
    private Boolean asyncInit;
    private String filters;
    private Boolean clearFiltersEnable;
    private Boolean resetStatEnable;
    private Integer notFullTimeoutRetryCount;
    private Integer maxWaitThreadCount;
    private Boolean failFast;
    private Integer phyTimeoutMillis;
    private Boolean keepAlive;
    private Boolean poolPreparedStatements;
    private Boolean initVariants;
    private Boolean initGlobalVariants;
    private Boolean useUnfairLock;
    private Boolean killWhenSocketReadTimeout;
    private Properties connectionProperties;
    private Integer maxPoolPreparedStatementPerConnectionSize;
    private String initConnectionSqls;
    private Boolean sharePreparedStatements;
    private Integer connectionErrorRetryAttempts;
    private Boolean breakAfterAcquireFailure;
    private String publicKey;
    @NestedConfigurationProperty
    private DruidWallConfig wall = new DruidWallConfig();
    @NestedConfigurationProperty
    private DruidStatConfig stat = new DruidStatConfig();
    private List<String> proxyFilters = new ArrayList<String>(2);

    public Properties toProperties(DruidConfig globalConfig) {
        Boolean tempMergeSql;
        Long tempSlowSqlMillis;
        Boolean tempLogSlowSql;
        String tempInitConnectionSqls;
        Integer tempMaxPoolPreparedStatementPerConnectionSize;
        Properties tempConnectProperties;
        Boolean tempKillWhenSocketReadTimeout;
        Boolean tempUseUnfairLock;
        Boolean tempInitGlobalVariants;
        Boolean tempInitVariants;
        Boolean tempPoolPreparedStatements;
        Boolean tempKeepAlive;
        Integer tempPhyTimeoutMillis;
        Boolean tempFailFast;
        Integer tempMaxWaitThreadCount;
        Integer tempNotFullTimeoutRetryCount;
        Boolean tempResetStatEnable;
        Boolean tempClearFiltersEnable;
        String tempFilters;
        Boolean tempAsyncInit;
        Boolean tempUseGlobalDataSourceStat;
        String tempValidationQuery;
        Boolean tempTestOnBorrow;
        Boolean tempTestWhileIdle;
        Long tempMaxEvictableIdleTimeMillis;
        Long tempMinEvictableIdleTimeMillis;
        Integer tempStatSqlMaxSize;
        Long tempTimeBetweenLogStatsMillis;
        Long tempTimeBetweenEvictionRunsMillis;
        Long tempMaxWait;
        Integer tempMinIdle;
        Integer tempMaxActive;
        Integer tempInitialSize;
        Properties properties = new Properties();
        Integer n = tempInitialSize = this.initialSize == null ? globalConfig.getInitialSize() : this.initialSize;
        if (tempInitialSize != null && !tempInitialSize.equals(0)) {
            properties.setProperty("druid.initialSize", String.valueOf(tempInitialSize));
        }
        Integer n2 = tempMaxActive = this.maxActive == null ? globalConfig.getMaxActive() : this.maxActive;
        if (tempMaxActive != null && !tempMaxActive.equals(-1)) {
            properties.setProperty("druid.maxActive", String.valueOf(tempMaxActive));
        }
        Integer n3 = tempMinIdle = this.minIdle == null ? globalConfig.getMinIdle() : this.minIdle;
        if (tempMinIdle != null && !tempMinIdle.equals(0)) {
            properties.setProperty("druid.minIdle", String.valueOf(tempMinIdle));
        }
        Long l = tempMaxWait = this.maxWait == null ? globalConfig.getMaxWait() : this.maxWait;
        if (tempMaxWait != null && !tempMaxWait.equals(-1)) {
            properties.setProperty("druid.maxWait", String.valueOf(tempMaxWait));
        }
        Long l2 = tempTimeBetweenEvictionRunsMillis = this.timeBetweenEvictionRunsMillis == null ? globalConfig.getTimeBetweenEvictionRunsMillis() : this.timeBetweenEvictionRunsMillis;
        if (tempTimeBetweenEvictionRunsMillis != null && !tempTimeBetweenEvictionRunsMillis.equals(60000L)) {
            properties.setProperty("druid.timeBetweenEvictionRunsMillis", String.valueOf(tempTimeBetweenEvictionRunsMillis));
        }
        Long l3 = tempTimeBetweenLogStatsMillis = this.timeBetweenLogStatsMillis == null ? globalConfig.getTimeBetweenLogStatsMillis() : this.timeBetweenLogStatsMillis;
        if (tempTimeBetweenLogStatsMillis != null && tempTimeBetweenLogStatsMillis > 0L) {
            properties.setProperty("druid.timeBetweenLogStatsMillis", String.valueOf(tempTimeBetweenLogStatsMillis));
        }
        Integer n4 = tempStatSqlMaxSize = this.statSqlMaxSize == null ? globalConfig.getStatSqlMaxSize() : this.statSqlMaxSize;
        if (tempStatSqlMaxSize != null) {
            properties.setProperty("druid.stat.sql.MaxSize", String.valueOf(tempStatSqlMaxSize));
        }
        Long l4 = tempMinEvictableIdleTimeMillis = this.minEvictableIdleTimeMillis == null ? globalConfig.getMinEvictableIdleTimeMillis() : this.minEvictableIdleTimeMillis;
        if (tempMinEvictableIdleTimeMillis != null && !tempMinEvictableIdleTimeMillis.equals(1800000L)) {
            properties.setProperty("druid.minEvictableIdleTimeMillis", String.valueOf(tempMinEvictableIdleTimeMillis));
        }
        Long l5 = tempMaxEvictableIdleTimeMillis = this.maxEvictableIdleTimeMillis == null ? globalConfig.getMaxEvictableIdleTimeMillis() : this.maxEvictableIdleTimeMillis;
        if (tempMaxEvictableIdleTimeMillis != null && !tempMaxEvictableIdleTimeMillis.equals(25200000L)) {
            properties.setProperty("druid.maxEvictableIdleTimeMillis", String.valueOf(tempMaxEvictableIdleTimeMillis));
        }
        Boolean bl = tempTestWhileIdle = this.testWhileIdle == null ? globalConfig.getTestWhileIdle() : this.testWhileIdle;
        if (tempTestWhileIdle != null && !tempTestWhileIdle.equals(true)) {
            properties.setProperty("druid.testWhileIdle", "false");
        }
        Boolean bl2 = tempTestOnBorrow = this.testOnBorrow == null ? globalConfig.getTestOnBorrow() : this.testOnBorrow;
        if (tempTestOnBorrow != null && !tempTestOnBorrow.equals(false)) {
            properties.setProperty("druid.testOnBorrow", "true");
        }
        String string = tempValidationQuery = this.validationQuery == null ? globalConfig.getValidationQuery() : this.validationQuery;
        if (tempValidationQuery != null && tempValidationQuery.length() > 0) {
            properties.setProperty("druid.validationQuery", tempValidationQuery);
        }
        Boolean bl3 = tempUseGlobalDataSourceStat = this.useGlobalDataSourceStat == null ? globalConfig.getUseGlobalDataSourceStat() : this.useGlobalDataSourceStat;
        if (tempUseGlobalDataSourceStat != null && tempUseGlobalDataSourceStat.equals(Boolean.TRUE)) {
            properties.setProperty("druid.useGlobalDataSourceStat", "true");
        }
        Boolean bl4 = tempAsyncInit = this.asyncInit == null ? globalConfig.getAsyncInit() : this.asyncInit;
        if (tempAsyncInit != null && tempAsyncInit.equals(Boolean.TRUE)) {
            properties.setProperty("druid.asyncInit", "true");
        }
        String string2 = tempFilters = this.filters == null ? globalConfig.getFilters() : this.filters;
        if (tempFilters == null) {
            tempFilters = "stat,wall";
        }
        if (this.publicKey != null && this.publicKey.length() > 0 && !tempFilters.contains("config")) {
            tempFilters = tempFilters + ",config";
        }
        properties.setProperty("druid.filters", tempFilters);
        Boolean bl5 = tempClearFiltersEnable = this.clearFiltersEnable == null ? globalConfig.getClearFiltersEnable() : this.clearFiltersEnable;
        if (tempClearFiltersEnable != null && tempClearFiltersEnable.equals(Boolean.FALSE)) {
            properties.setProperty("druid.clearFiltersEnable", "false");
        }
        Boolean bl6 = tempResetStatEnable = this.resetStatEnable == null ? globalConfig.getResetStatEnable() : this.resetStatEnable;
        if (tempResetStatEnable != null && tempResetStatEnable.equals(Boolean.FALSE)) {
            properties.setProperty("druid.resetStatEnable", "false");
        }
        Integer n5 = tempNotFullTimeoutRetryCount = this.notFullTimeoutRetryCount == null ? globalConfig.getNotFullTimeoutRetryCount() : this.notFullTimeoutRetryCount;
        if (tempNotFullTimeoutRetryCount != null && !tempNotFullTimeoutRetryCount.equals(0)) {
            properties.setProperty("druid.notFullTimeoutRetryCount", String.valueOf(tempNotFullTimeoutRetryCount));
        }
        Integer n6 = tempMaxWaitThreadCount = this.maxWaitThreadCount == null ? globalConfig.getMaxWaitThreadCount() : this.maxWaitThreadCount;
        if (tempMaxWaitThreadCount != null && !tempMaxWaitThreadCount.equals(-1)) {
            properties.setProperty("druid.maxWaitThreadCount", String.valueOf(tempMaxWaitThreadCount));
        }
        Boolean bl7 = tempFailFast = this.failFast == null ? globalConfig.getFailFast() : this.failFast;
        if (tempFailFast != null && tempFailFast.equals(Boolean.TRUE)) {
            properties.setProperty("druid.failFast", "true");
        }
        Integer n7 = tempPhyTimeoutMillis = this.phyTimeoutMillis == null ? globalConfig.getPhyTimeoutMillis() : this.phyTimeoutMillis;
        if (tempPhyTimeoutMillis != null && !tempPhyTimeoutMillis.equals(-1L)) {
            properties.setProperty("druid.phyTimeoutMillis", String.valueOf(tempPhyTimeoutMillis));
        }
        Boolean bl8 = tempKeepAlive = this.keepAlive == null ? globalConfig.getKeepAlive() : this.keepAlive;
        if (tempKeepAlive != null && tempKeepAlive.equals(Boolean.TRUE)) {
            properties.setProperty("druid.keepAlive", "true");
        }
        Boolean bl9 = tempPoolPreparedStatements = this.poolPreparedStatements == null ? globalConfig.getPoolPreparedStatements() : this.poolPreparedStatements;
        if (tempPoolPreparedStatements != null && tempPoolPreparedStatements.equals(Boolean.TRUE)) {
            properties.setProperty("druid.poolPreparedStatements", "true");
        }
        Boolean bl10 = tempInitVariants = this.initVariants == null ? globalConfig.getInitVariants() : this.initVariants;
        if (tempInitVariants != null && tempInitVariants.equals(Boolean.TRUE)) {
            properties.setProperty("druid.initVariants", "true");
        }
        Boolean bl11 = tempInitGlobalVariants = this.initGlobalVariants == null ? globalConfig.getInitGlobalVariants() : this.initGlobalVariants;
        if (tempInitGlobalVariants != null && tempInitGlobalVariants.equals(Boolean.TRUE)) {
            properties.setProperty("druid.initGlobalVariants", "true");
        }
        Boolean bl12 = tempUseUnfairLock = this.useUnfairLock == null ? globalConfig.getUseUnfairLock() : this.useUnfairLock;
        if (tempUseUnfairLock != null) {
            properties.setProperty("druid.useUnfairLock", String.valueOf(tempUseUnfairLock));
        }
        Boolean bl13 = tempKillWhenSocketReadTimeout = this.killWhenSocketReadTimeout == null ? globalConfig.getKillWhenSocketReadTimeout() : this.killWhenSocketReadTimeout;
        if (tempKillWhenSocketReadTimeout != null && tempKillWhenSocketReadTimeout.equals(Boolean.TRUE)) {
            properties.setProperty("druid.killWhenSocketReadTimeout", "true");
        }
        Properties properties2 = tempConnectProperties = this.connectionProperties == null ? globalConfig.getConnectionProperties() : this.connectionProperties;
        if (this.publicKey != null && this.publicKey.length() > 0) {
            if (tempConnectProperties == null) {
                tempConnectProperties = new Properties();
            }
            log.info("\u52a8\u6001\u6570\u636e\u6e90-\u68c0\u6d4b\u5230\u60a8\u914d\u7f6e\u4e86druid\u52a0\u5bc6,\u52a0\u5bc6\u6240\u9700\u8fde\u63a5\u53c2\u6570\u5df2\u4e3a\u60a8\u81ea\u52a8\u914d\u7f6e");
            tempConnectProperties.setProperty("config.decrypt", "true");
            tempConnectProperties.setProperty("config.decrypt.key", this.publicKey);
        }
        this.connectionProperties = tempConnectProperties;
        Integer n8 = tempMaxPoolPreparedStatementPerConnectionSize = this.maxPoolPreparedStatementPerConnectionSize == null ? globalConfig.getMaxPoolPreparedStatementPerConnectionSize() : this.maxPoolPreparedStatementPerConnectionSize;
        if (tempMaxPoolPreparedStatementPerConnectionSize != null && !tempMaxPoolPreparedStatementPerConnectionSize.equals(10)) {
            properties.setProperty("druid.maxPoolPreparedStatementPerConnectionSize", String.valueOf(tempMaxPoolPreparedStatementPerConnectionSize));
        }
        String string3 = tempInitConnectionSqls = this.initConnectionSqls == null ? globalConfig.getInitConnectionSqls() : this.initConnectionSqls;
        if (tempInitConnectionSqls != null && tempInitConnectionSqls.length() > 0) {
            properties.setProperty("druid.initConnectionSqls", tempInitConnectionSqls);
        }
        Boolean bl14 = tempLogSlowSql = this.stat.getLogSlowSql() == null ? globalConfig.stat.getLogSlowSql() : this.stat.getLogSlowSql();
        if (tempLogSlowSql != null && tempLogSlowSql.booleanValue()) {
            properties.setProperty("druid.stat.logSlowSql", "true");
        }
        Long l6 = tempSlowSqlMillis = this.stat.getSlowSqlMillis() == null ? globalConfig.stat.getSlowSqlMillis() : this.stat.getSlowSqlMillis();
        if (tempSlowSqlMillis != null) {
            properties.setProperty("druid.stat.slowSqlMillis", tempSlowSqlMillis.toString());
        }
        Boolean bl15 = tempMergeSql = this.stat.getMergeSql() == null ? globalConfig.stat.getMergeSql() : this.stat.getMergeSql();
        if (tempMergeSql != null && tempMergeSql.booleanValue()) {
            properties.setProperty("druid.stat.mergeSql", "true");
        }
        return properties;
    }

    public List<String> getProxyFilters() {
        return this.proxyFilters;
    }

    public void setProxyFilters(List<String> proxyFilters) {
        this.proxyFilters = proxyFilters;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Long getMaxWait() {
        return this.maxWait;
    }

    public Long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public Long getTimeBetweenLogStatsMillis() {
        return this.timeBetweenLogStatsMillis;
    }

    public Integer getStatSqlMaxSize() {
        return this.statSqlMaxSize;
    }

    public Long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public Long getMaxEvictableIdleTimeMillis() {
        return this.maxEvictableIdleTimeMillis;
    }

    public Boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public Boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public Boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Integer getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public Boolean getUseGlobalDataSourceStat() {
        return this.useGlobalDataSourceStat;
    }

    public Boolean getAsyncInit() {
        return this.asyncInit;
    }

    public String getFilters() {
        return this.filters;
    }

    public Boolean getClearFiltersEnable() {
        return this.clearFiltersEnable;
    }

    public Boolean getResetStatEnable() {
        return this.resetStatEnable;
    }

    public Integer getNotFullTimeoutRetryCount() {
        return this.notFullTimeoutRetryCount;
    }

    public Integer getMaxWaitThreadCount() {
        return this.maxWaitThreadCount;
    }

    public Boolean getFailFast() {
        return this.failFast;
    }

    public Integer getPhyTimeoutMillis() {
        return this.phyTimeoutMillis;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public Boolean getPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public Boolean getInitVariants() {
        return this.initVariants;
    }

    public Boolean getInitGlobalVariants() {
        return this.initGlobalVariants;
    }

    public Boolean getUseUnfairLock() {
        return this.useUnfairLock;
    }

    public Boolean getKillWhenSocketReadTimeout() {
        return this.killWhenSocketReadTimeout;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public Integer getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public String getInitConnectionSqls() {
        return this.initConnectionSqls;
    }

    public Boolean getSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public Integer getConnectionErrorRetryAttempts() {
        return this.connectionErrorRetryAttempts;
    }

    public Boolean getBreakAfterAcquireFailure() {
        return this.breakAfterAcquireFailure;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public DruidWallConfig getWall() {
        return this.wall;
    }

    public DruidStatConfig getStat() {
        return this.stat;
    }

    public DruidConfig setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
        return this;
    }

    public DruidConfig setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public DruidConfig setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public DruidConfig setMaxWait(Long maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public DruidConfig setTimeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        return this;
    }

    public DruidConfig setTimeBetweenLogStatsMillis(Long timeBetweenLogStatsMillis) {
        this.timeBetweenLogStatsMillis = timeBetweenLogStatsMillis;
        return this;
    }

    public DruidConfig setStatSqlMaxSize(Integer statSqlMaxSize) {
        this.statSqlMaxSize = statSqlMaxSize;
        return this;
    }

    public DruidConfig setMinEvictableIdleTimeMillis(Long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        return this;
    }

    public DruidConfig setMaxEvictableIdleTimeMillis(Long maxEvictableIdleTimeMillis) {
        this.maxEvictableIdleTimeMillis = maxEvictableIdleTimeMillis;
        return this;
    }

    public DruidConfig setTestWhileIdle(Boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public DruidConfig setTestOnBorrow(Boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public DruidConfig setTestOnReturn(Boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public DruidConfig setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        return this;
    }

    public DruidConfig setValidationQueryTimeout(Integer validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
        return this;
    }

    public DruidConfig setUseGlobalDataSourceStat(Boolean useGlobalDataSourceStat) {
        this.useGlobalDataSourceStat = useGlobalDataSourceStat;
        return this;
    }

    public DruidConfig setAsyncInit(Boolean asyncInit) {
        this.asyncInit = asyncInit;
        return this;
    }

    public DruidConfig setFilters(String filters) {
        this.filters = filters;
        return this;
    }

    public DruidConfig setClearFiltersEnable(Boolean clearFiltersEnable) {
        this.clearFiltersEnable = clearFiltersEnable;
        return this;
    }

    public DruidConfig setResetStatEnable(Boolean resetStatEnable) {
        this.resetStatEnable = resetStatEnable;
        return this;
    }

    public DruidConfig setNotFullTimeoutRetryCount(Integer notFullTimeoutRetryCount) {
        this.notFullTimeoutRetryCount = notFullTimeoutRetryCount;
        return this;
    }

    public DruidConfig setMaxWaitThreadCount(Integer maxWaitThreadCount) {
        this.maxWaitThreadCount = maxWaitThreadCount;
        return this;
    }

    public DruidConfig setFailFast(Boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public DruidConfig setPhyTimeoutMillis(Integer phyTimeoutMillis) {
        this.phyTimeoutMillis = phyTimeoutMillis;
        return this;
    }

    public DruidConfig setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public DruidConfig setPoolPreparedStatements(Boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
        return this;
    }

    public DruidConfig setInitVariants(Boolean initVariants) {
        this.initVariants = initVariants;
        return this;
    }

    public DruidConfig setInitGlobalVariants(Boolean initGlobalVariants) {
        this.initGlobalVariants = initGlobalVariants;
        return this;
    }

    public DruidConfig setUseUnfairLock(Boolean useUnfairLock) {
        this.useUnfairLock = useUnfairLock;
        return this;
    }

    public DruidConfig setKillWhenSocketReadTimeout(Boolean killWhenSocketReadTimeout) {
        this.killWhenSocketReadTimeout = killWhenSocketReadTimeout;
        return this;
    }

    public DruidConfig setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public DruidConfig setMaxPoolPreparedStatementPerConnectionSize(Integer maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
        return this;
    }

    public DruidConfig setInitConnectionSqls(String initConnectionSqls) {
        this.initConnectionSqls = initConnectionSqls;
        return this;
    }

    public DruidConfig setSharePreparedStatements(Boolean sharePreparedStatements) {
        this.sharePreparedStatements = sharePreparedStatements;
        return this;
    }

    public DruidConfig setConnectionErrorRetryAttempts(Integer connectionErrorRetryAttempts) {
        this.connectionErrorRetryAttempts = connectionErrorRetryAttempts;
        return this;
    }

    public DruidConfig setBreakAfterAcquireFailure(Boolean breakAfterAcquireFailure) {
        this.breakAfterAcquireFailure = breakAfterAcquireFailure;
        return this;
    }

    public DruidConfig setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public DruidConfig setWall(DruidWallConfig wall) {
        this.wall = wall;
        return this;
    }

    public DruidConfig setStat(DruidStatConfig stat) {
        this.stat = stat;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidConfig)) {
            return false;
        }
        DruidConfig other = (DruidConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$initialSize = this.getInitialSize();
        Integer other$initialSize = other.getInitialSize();
        if (this$initialSize == null ? other$initialSize != null : !((Object)this$initialSize).equals(other$initialSize)) {
            return false;
        }
        Integer this$maxActive = this.getMaxActive();
        Integer other$maxActive = other.getMaxActive();
        if (this$maxActive == null ? other$maxActive != null : !((Object)this$maxActive).equals(other$maxActive)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        Long this$maxWait = this.getMaxWait();
        Long other$maxWait = other.getMaxWait();
        if (this$maxWait == null ? other$maxWait != null : !((Object)this$maxWait).equals(other$maxWait)) {
            return false;
        }
        Long this$timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        Long other$timeBetweenEvictionRunsMillis = other.getTimeBetweenEvictionRunsMillis();
        if (this$timeBetweenEvictionRunsMillis == null ? other$timeBetweenEvictionRunsMillis != null : !((Object)this$timeBetweenEvictionRunsMillis).equals(other$timeBetweenEvictionRunsMillis)) {
            return false;
        }
        Long this$timeBetweenLogStatsMillis = this.getTimeBetweenLogStatsMillis();
        Long other$timeBetweenLogStatsMillis = other.getTimeBetweenLogStatsMillis();
        if (this$timeBetweenLogStatsMillis == null ? other$timeBetweenLogStatsMillis != null : !((Object)this$timeBetweenLogStatsMillis).equals(other$timeBetweenLogStatsMillis)) {
            return false;
        }
        Integer this$statSqlMaxSize = this.getStatSqlMaxSize();
        Integer other$statSqlMaxSize = other.getStatSqlMaxSize();
        if (this$statSqlMaxSize == null ? other$statSqlMaxSize != null : !((Object)this$statSqlMaxSize).equals(other$statSqlMaxSize)) {
            return false;
        }
        Long this$minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        Long other$minEvictableIdleTimeMillis = other.getMinEvictableIdleTimeMillis();
        if (this$minEvictableIdleTimeMillis == null ? other$minEvictableIdleTimeMillis != null : !((Object)this$minEvictableIdleTimeMillis).equals(other$minEvictableIdleTimeMillis)) {
            return false;
        }
        Long this$maxEvictableIdleTimeMillis = this.getMaxEvictableIdleTimeMillis();
        Long other$maxEvictableIdleTimeMillis = other.getMaxEvictableIdleTimeMillis();
        if (this$maxEvictableIdleTimeMillis == null ? other$maxEvictableIdleTimeMillis != null : !((Object)this$maxEvictableIdleTimeMillis).equals(other$maxEvictableIdleTimeMillis)) {
            return false;
        }
        Boolean this$testWhileIdle = this.getTestWhileIdle();
        Boolean other$testWhileIdle = other.getTestWhileIdle();
        if (this$testWhileIdle == null ? other$testWhileIdle != null : !((Object)this$testWhileIdle).equals(other$testWhileIdle)) {
            return false;
        }
        Boolean this$testOnBorrow = this.getTestOnBorrow();
        Boolean other$testOnBorrow = other.getTestOnBorrow();
        if (this$testOnBorrow == null ? other$testOnBorrow != null : !((Object)this$testOnBorrow).equals(other$testOnBorrow)) {
            return false;
        }
        Boolean this$testOnReturn = this.getTestOnReturn();
        Boolean other$testOnReturn = other.getTestOnReturn();
        if (this$testOnReturn == null ? other$testOnReturn != null : !((Object)this$testOnReturn).equals(other$testOnReturn)) {
            return false;
        }
        String this$validationQuery = this.getValidationQuery();
        String other$validationQuery = other.getValidationQuery();
        if (this$validationQuery == null ? other$validationQuery != null : !this$validationQuery.equals(other$validationQuery)) {
            return false;
        }
        Integer this$validationQueryTimeout = this.getValidationQueryTimeout();
        Integer other$validationQueryTimeout = other.getValidationQueryTimeout();
        if (this$validationQueryTimeout == null ? other$validationQueryTimeout != null : !((Object)this$validationQueryTimeout).equals(other$validationQueryTimeout)) {
            return false;
        }
        Boolean this$useGlobalDataSourceStat = this.getUseGlobalDataSourceStat();
        Boolean other$useGlobalDataSourceStat = other.getUseGlobalDataSourceStat();
        if (this$useGlobalDataSourceStat == null ? other$useGlobalDataSourceStat != null : !((Object)this$useGlobalDataSourceStat).equals(other$useGlobalDataSourceStat)) {
            return false;
        }
        Boolean this$asyncInit = this.getAsyncInit();
        Boolean other$asyncInit = other.getAsyncInit();
        if (this$asyncInit == null ? other$asyncInit != null : !((Object)this$asyncInit).equals(other$asyncInit)) {
            return false;
        }
        String this$filters = this.getFilters();
        String other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) {
            return false;
        }
        Boolean this$clearFiltersEnable = this.getClearFiltersEnable();
        Boolean other$clearFiltersEnable = other.getClearFiltersEnable();
        if (this$clearFiltersEnable == null ? other$clearFiltersEnable != null : !((Object)this$clearFiltersEnable).equals(other$clearFiltersEnable)) {
            return false;
        }
        Boolean this$resetStatEnable = this.getResetStatEnable();
        Boolean other$resetStatEnable = other.getResetStatEnable();
        if (this$resetStatEnable == null ? other$resetStatEnable != null : !((Object)this$resetStatEnable).equals(other$resetStatEnable)) {
            return false;
        }
        Integer this$notFullTimeoutRetryCount = this.getNotFullTimeoutRetryCount();
        Integer other$notFullTimeoutRetryCount = other.getNotFullTimeoutRetryCount();
        if (this$notFullTimeoutRetryCount == null ? other$notFullTimeoutRetryCount != null : !((Object)this$notFullTimeoutRetryCount).equals(other$notFullTimeoutRetryCount)) {
            return false;
        }
        Integer this$maxWaitThreadCount = this.getMaxWaitThreadCount();
        Integer other$maxWaitThreadCount = other.getMaxWaitThreadCount();
        if (this$maxWaitThreadCount == null ? other$maxWaitThreadCount != null : !((Object)this$maxWaitThreadCount).equals(other$maxWaitThreadCount)) {
            return false;
        }
        Boolean this$failFast = this.getFailFast();
        Boolean other$failFast = other.getFailFast();
        if (this$failFast == null ? other$failFast != null : !((Object)this$failFast).equals(other$failFast)) {
            return false;
        }
        Integer this$phyTimeoutMillis = this.getPhyTimeoutMillis();
        Integer other$phyTimeoutMillis = other.getPhyTimeoutMillis();
        if (this$phyTimeoutMillis == null ? other$phyTimeoutMillis != null : !((Object)this$phyTimeoutMillis).equals(other$phyTimeoutMillis)) {
            return false;
        }
        Boolean this$keepAlive = this.getKeepAlive();
        Boolean other$keepAlive = other.getKeepAlive();
        if (this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive)) {
            return false;
        }
        Boolean this$poolPreparedStatements = this.getPoolPreparedStatements();
        Boolean other$poolPreparedStatements = other.getPoolPreparedStatements();
        if (this$poolPreparedStatements == null ? other$poolPreparedStatements != null : !((Object)this$poolPreparedStatements).equals(other$poolPreparedStatements)) {
            return false;
        }
        Boolean this$initVariants = this.getInitVariants();
        Boolean other$initVariants = other.getInitVariants();
        if (this$initVariants == null ? other$initVariants != null : !((Object)this$initVariants).equals(other$initVariants)) {
            return false;
        }
        Boolean this$initGlobalVariants = this.getInitGlobalVariants();
        Boolean other$initGlobalVariants = other.getInitGlobalVariants();
        if (this$initGlobalVariants == null ? other$initGlobalVariants != null : !((Object)this$initGlobalVariants).equals(other$initGlobalVariants)) {
            return false;
        }
        Boolean this$useUnfairLock = this.getUseUnfairLock();
        Boolean other$useUnfairLock = other.getUseUnfairLock();
        if (this$useUnfairLock == null ? other$useUnfairLock != null : !((Object)this$useUnfairLock).equals(other$useUnfairLock)) {
            return false;
        }
        Boolean this$killWhenSocketReadTimeout = this.getKillWhenSocketReadTimeout();
        Boolean other$killWhenSocketReadTimeout = other.getKillWhenSocketReadTimeout();
        if (this$killWhenSocketReadTimeout == null ? other$killWhenSocketReadTimeout != null : !((Object)this$killWhenSocketReadTimeout).equals(other$killWhenSocketReadTimeout)) {
            return false;
        }
        Properties this$connectionProperties = this.getConnectionProperties();
        Properties other$connectionProperties = other.getConnectionProperties();
        if (this$connectionProperties == null ? other$connectionProperties != null : !((Object)this$connectionProperties).equals(other$connectionProperties)) {
            return false;
        }
        Integer this$maxPoolPreparedStatementPerConnectionSize = this.getMaxPoolPreparedStatementPerConnectionSize();
        Integer other$maxPoolPreparedStatementPerConnectionSize = other.getMaxPoolPreparedStatementPerConnectionSize();
        if (this$maxPoolPreparedStatementPerConnectionSize == null ? other$maxPoolPreparedStatementPerConnectionSize != null : !((Object)this$maxPoolPreparedStatementPerConnectionSize).equals(other$maxPoolPreparedStatementPerConnectionSize)) {
            return false;
        }
        String this$initConnectionSqls = this.getInitConnectionSqls();
        String other$initConnectionSqls = other.getInitConnectionSqls();
        if (this$initConnectionSqls == null ? other$initConnectionSqls != null : !this$initConnectionSqls.equals(other$initConnectionSqls)) {
            return false;
        }
        Boolean this$sharePreparedStatements = this.getSharePreparedStatements();
        Boolean other$sharePreparedStatements = other.getSharePreparedStatements();
        if (this$sharePreparedStatements == null ? other$sharePreparedStatements != null : !((Object)this$sharePreparedStatements).equals(other$sharePreparedStatements)) {
            return false;
        }
        Integer this$connectionErrorRetryAttempts = this.getConnectionErrorRetryAttempts();
        Integer other$connectionErrorRetryAttempts = other.getConnectionErrorRetryAttempts();
        if (this$connectionErrorRetryAttempts == null ? other$connectionErrorRetryAttempts != null : !((Object)this$connectionErrorRetryAttempts).equals(other$connectionErrorRetryAttempts)) {
            return false;
        }
        Boolean this$breakAfterAcquireFailure = this.getBreakAfterAcquireFailure();
        Boolean other$breakAfterAcquireFailure = other.getBreakAfterAcquireFailure();
        if (this$breakAfterAcquireFailure == null ? other$breakAfterAcquireFailure != null : !((Object)this$breakAfterAcquireFailure).equals(other$breakAfterAcquireFailure)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        DruidWallConfig this$wall = this.getWall();
        DruidWallConfig other$wall = other.getWall();
        if (this$wall == null ? other$wall != null : !((Object)this$wall).equals(other$wall)) {
            return false;
        }
        DruidStatConfig this$stat = this.getStat();
        DruidStatConfig other$stat = other.getStat();
        if (this$stat == null ? other$stat != null : !((Object)this$stat).equals(other$stat)) {
            return false;
        }
        List<String> this$proxyFilters = this.getProxyFilters();
        List<String> other$proxyFilters = other.getProxyFilters();
        return !(this$proxyFilters == null ? other$proxyFilters != null : !((Object)this$proxyFilters).equals(other$proxyFilters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DruidConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $initialSize = this.getInitialSize();
        result = result * 59 + ($initialSize == null ? 43 : ((Object)$initialSize).hashCode());
        Integer $maxActive = this.getMaxActive();
        result = result * 59 + ($maxActive == null ? 43 : ((Object)$maxActive).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        Long $maxWait = this.getMaxWait();
        result = result * 59 + ($maxWait == null ? 43 : ((Object)$maxWait).hashCode());
        Long $timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        result = result * 59 + ($timeBetweenEvictionRunsMillis == null ? 43 : ((Object)$timeBetweenEvictionRunsMillis).hashCode());
        Long $timeBetweenLogStatsMillis = this.getTimeBetweenLogStatsMillis();
        result = result * 59 + ($timeBetweenLogStatsMillis == null ? 43 : ((Object)$timeBetweenLogStatsMillis).hashCode());
        Integer $statSqlMaxSize = this.getStatSqlMaxSize();
        result = result * 59 + ($statSqlMaxSize == null ? 43 : ((Object)$statSqlMaxSize).hashCode());
        Long $minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        result = result * 59 + ($minEvictableIdleTimeMillis == null ? 43 : ((Object)$minEvictableIdleTimeMillis).hashCode());
        Long $maxEvictableIdleTimeMillis = this.getMaxEvictableIdleTimeMillis();
        result = result * 59 + ($maxEvictableIdleTimeMillis == null ? 43 : ((Object)$maxEvictableIdleTimeMillis).hashCode());
        Boolean $testWhileIdle = this.getTestWhileIdle();
        result = result * 59 + ($testWhileIdle == null ? 43 : ((Object)$testWhileIdle).hashCode());
        Boolean $testOnBorrow = this.getTestOnBorrow();
        result = result * 59 + ($testOnBorrow == null ? 43 : ((Object)$testOnBorrow).hashCode());
        Boolean $testOnReturn = this.getTestOnReturn();
        result = result * 59 + ($testOnReturn == null ? 43 : ((Object)$testOnReturn).hashCode());
        String $validationQuery = this.getValidationQuery();
        result = result * 59 + ($validationQuery == null ? 43 : $validationQuery.hashCode());
        Integer $validationQueryTimeout = this.getValidationQueryTimeout();
        result = result * 59 + ($validationQueryTimeout == null ? 43 : ((Object)$validationQueryTimeout).hashCode());
        Boolean $useGlobalDataSourceStat = this.getUseGlobalDataSourceStat();
        result = result * 59 + ($useGlobalDataSourceStat == null ? 43 : ((Object)$useGlobalDataSourceStat).hashCode());
        Boolean $asyncInit = this.getAsyncInit();
        result = result * 59 + ($asyncInit == null ? 43 : ((Object)$asyncInit).hashCode());
        String $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
        Boolean $clearFiltersEnable = this.getClearFiltersEnable();
        result = result * 59 + ($clearFiltersEnable == null ? 43 : ((Object)$clearFiltersEnable).hashCode());
        Boolean $resetStatEnable = this.getResetStatEnable();
        result = result * 59 + ($resetStatEnable == null ? 43 : ((Object)$resetStatEnable).hashCode());
        Integer $notFullTimeoutRetryCount = this.getNotFullTimeoutRetryCount();
        result = result * 59 + ($notFullTimeoutRetryCount == null ? 43 : ((Object)$notFullTimeoutRetryCount).hashCode());
        Integer $maxWaitThreadCount = this.getMaxWaitThreadCount();
        result = result * 59 + ($maxWaitThreadCount == null ? 43 : ((Object)$maxWaitThreadCount).hashCode());
        Boolean $failFast = this.getFailFast();
        result = result * 59 + ($failFast == null ? 43 : ((Object)$failFast).hashCode());
        Integer $phyTimeoutMillis = this.getPhyTimeoutMillis();
        result = result * 59 + ($phyTimeoutMillis == null ? 43 : ((Object)$phyTimeoutMillis).hashCode());
        Boolean $keepAlive = this.getKeepAlive();
        result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
        Boolean $poolPreparedStatements = this.getPoolPreparedStatements();
        result = result * 59 + ($poolPreparedStatements == null ? 43 : ((Object)$poolPreparedStatements).hashCode());
        Boolean $initVariants = this.getInitVariants();
        result = result * 59 + ($initVariants == null ? 43 : ((Object)$initVariants).hashCode());
        Boolean $initGlobalVariants = this.getInitGlobalVariants();
        result = result * 59 + ($initGlobalVariants == null ? 43 : ((Object)$initGlobalVariants).hashCode());
        Boolean $useUnfairLock = this.getUseUnfairLock();
        result = result * 59 + ($useUnfairLock == null ? 43 : ((Object)$useUnfairLock).hashCode());
        Boolean $killWhenSocketReadTimeout = this.getKillWhenSocketReadTimeout();
        result = result * 59 + ($killWhenSocketReadTimeout == null ? 43 : ((Object)$killWhenSocketReadTimeout).hashCode());
        Properties $connectionProperties = this.getConnectionProperties();
        result = result * 59 + ($connectionProperties == null ? 43 : ((Object)$connectionProperties).hashCode());
        Integer $maxPoolPreparedStatementPerConnectionSize = this.getMaxPoolPreparedStatementPerConnectionSize();
        result = result * 59 + ($maxPoolPreparedStatementPerConnectionSize == null ? 43 : ((Object)$maxPoolPreparedStatementPerConnectionSize).hashCode());
        String $initConnectionSqls = this.getInitConnectionSqls();
        result = result * 59 + ($initConnectionSqls == null ? 43 : $initConnectionSqls.hashCode());
        Boolean $sharePreparedStatements = this.getSharePreparedStatements();
        result = result * 59 + ($sharePreparedStatements == null ? 43 : ((Object)$sharePreparedStatements).hashCode());
        Integer $connectionErrorRetryAttempts = this.getConnectionErrorRetryAttempts();
        result = result * 59 + ($connectionErrorRetryAttempts == null ? 43 : ((Object)$connectionErrorRetryAttempts).hashCode());
        Boolean $breakAfterAcquireFailure = this.getBreakAfterAcquireFailure();
        result = result * 59 + ($breakAfterAcquireFailure == null ? 43 : ((Object)$breakAfterAcquireFailure).hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        DruidWallConfig $wall = this.getWall();
        result = result * 59 + ($wall == null ? 43 : ((Object)$wall).hashCode());
        DruidStatConfig $stat = this.getStat();
        result = result * 59 + ($stat == null ? 43 : ((Object)$stat).hashCode());
        List<String> $proxyFilters = this.getProxyFilters();
        result = result * 59 + ($proxyFilters == null ? 43 : ((Object)$proxyFilters).hashCode());
        return result;
    }

    public String toString() {
        return "DruidConfig(initialSize=" + this.getInitialSize() + ", maxActive=" + this.getMaxActive() + ", minIdle=" + this.getMinIdle() + ", maxWait=" + this.getMaxWait() + ", timeBetweenEvictionRunsMillis=" + this.getTimeBetweenEvictionRunsMillis() + ", timeBetweenLogStatsMillis=" + this.getTimeBetweenLogStatsMillis() + ", statSqlMaxSize=" + this.getStatSqlMaxSize() + ", minEvictableIdleTimeMillis=" + this.getMinEvictableIdleTimeMillis() + ", maxEvictableIdleTimeMillis=" + this.getMaxEvictableIdleTimeMillis() + ", testWhileIdle=" + this.getTestWhileIdle() + ", testOnBorrow=" + this.getTestOnBorrow() + ", testOnReturn=" + this.getTestOnReturn() + ", validationQuery=" + this.getValidationQuery() + ", validationQueryTimeout=" + this.getValidationQueryTimeout() + ", useGlobalDataSourceStat=" + this.getUseGlobalDataSourceStat() + ", asyncInit=" + this.getAsyncInit() + ", filters=" + this.getFilters() + ", clearFiltersEnable=" + this.getClearFiltersEnable() + ", resetStatEnable=" + this.getResetStatEnable() + ", notFullTimeoutRetryCount=" + this.getNotFullTimeoutRetryCount() + ", maxWaitThreadCount=" + this.getMaxWaitThreadCount() + ", failFast=" + this.getFailFast() + ", phyTimeoutMillis=" + this.getPhyTimeoutMillis() + ", keepAlive=" + this.getKeepAlive() + ", poolPreparedStatements=" + this.getPoolPreparedStatements() + ", initVariants=" + this.getInitVariants() + ", initGlobalVariants=" + this.getInitGlobalVariants() + ", useUnfairLock=" + this.getUseUnfairLock() + ", killWhenSocketReadTimeout=" + this.getKillWhenSocketReadTimeout() + ", connectionProperties=" + this.getConnectionProperties() + ", maxPoolPreparedStatementPerConnectionSize=" + this.getMaxPoolPreparedStatementPerConnectionSize() + ", initConnectionSqls=" + this.getInitConnectionSqls() + ", sharePreparedStatements=" + this.getSharePreparedStatements() + ", connectionErrorRetryAttempts=" + this.getConnectionErrorRetryAttempts() + ", breakAfterAcquireFailure=" + this.getBreakAfterAcquireFailure() + ", publicKey=" + this.getPublicKey() + ", wall=" + this.getWall() + ", stat=" + this.getStat() + ", proxyFilters=" + this.getProxyFilters() + ")";
    }
}

