/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock;

import com.baomidou.lock.LockKeyBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

public class DefaultLockKeyBuilder
implements LockKeyBuilder {
    private static final String DEFAULT_KEY_PREFIX = "lock4j";
    private static final ParameterNameDiscoverer NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    @Override
    public String buildKey(MethodInvocation invocation, String[] definitionKeys) {
        StringBuilder sb = new StringBuilder(this.getKeyPrefix());
        Method method = invocation.getMethod();
        sb.append(":").append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("#");
        if (definitionKeys.length > 1 || !"".equals(definitionKeys[0])) {
            sb.append(this.getSpelDefinitionKey(definitionKeys, method, invocation.getArguments()));
        }
        return sb.toString();
    }

    protected String getSpelDefinitionKey(String[] definitionKeys, Method method, Object[] parameterValues) {
        MethodBasedEvaluationContext context = new MethodBasedEvaluationContext(null, method, parameterValues, NAME_DISCOVERER);
        ArrayList<String> definitionKeyList = new ArrayList<String>(definitionKeys.length);
        for (String definitionKey : definitionKeys) {
            if (definitionKey == null || definitionKey.isEmpty()) continue;
            String key = PARSER.parseExpression(definitionKey).getValue((EvaluationContext)context).toString();
            definitionKeyList.add(key);
        }
        return StringUtils.collectionToDelimitedString(definitionKeyList, (String)".", (String)"", (String)"");
    }

    protected String getKeyPrefix() {
        return DEFAULT_KEY_PREFIX;
    }
}

