/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.util.SignUtils;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public class WxPayEntrustResult
extends BaseWxPayResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XStreamAlias(value="contract_result_code")
    private String contractResultCode;
    @XStreamAlias(value="contract_err_code")
    private String contractErrCode;
    @XStreamAlias(value="contract_err_code_des")
    private String contractErrCodeDes;
    @XStreamAlias(value="prepay_id")
    private String prepayId;
    @XStreamAlias(value="trade_type")
    private String tradeType;
    @XStreamAlias(value="code_url")
    private String codeUrl;
    @XStreamAlias(value="plan_id")
    private Integer planId;
    @XStreamAlias(value="request_serial")
    private Integer requestSerial;
    @XStreamAlias(value="contract_code")
    private String contractCode;
    @XStreamAlias(value="contract_display_account")
    private String contractDisplayAccount;
    @XStreamAlias(value="mweb_url")
    private String mwebUrl;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;

    @Override
    protected void loadXml(Document d) {
        this.contractResultCode = WxPayEntrustResult.readXmlString(d, "contract_result_code");
        this.contractErrCode = WxPayEntrustResult.readXmlString(d, "contract_err_code");
        this.contractErrCodeDes = WxPayEntrustResult.readXmlString(d, "contract_err_code_des");
        this.prepayId = WxPayEntrustResult.readXmlString(d, "prepay_id");
        this.tradeType = WxPayEntrustResult.readXmlString(d, "trade_type");
        this.codeUrl = WxPayEntrustResult.readXmlString(d, "code_url");
        this.planId = WxPayEntrustResult.readXmlInteger(d, "plan_id");
        this.requestSerial = WxPayEntrustResult.readXmlInteger(d, "request_serial");
        this.contractCode = WxPayEntrustResult.readXmlString(d, "contract_code");
        this.contractDisplayAccount = WxPayEntrustResult.readXmlString(d, "contract_display_account");
        this.mwebUrl = WxPayEntrustResult.readXmlString(d, "mweb_url");
        this.outTradeNo = WxPayEntrustResult.readXmlString(d, "out_trade_no");
    }

    @Override
    public void checkResult(WxPayService wxPayService, String signType, boolean checkSuccess) throws WxPayException {
        ArrayList successStrings;
        Map<String, String> map = this.toMap();
        if (this.getSign() != null && !SignUtils.checkSign(map, signType, wxPayService.getConfig().getMchKey())) {
            this.getLogger().debug("\u6821\u9a8c\u7ed3\u679c\u7b7e\u540d\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", map);
            throw new WxPayException("\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u9519\u8bef\uff01");
        }
        if (!(!checkSuccess || (successStrings = Lists.newArrayList((Object[])new String[]{"SUCCESS", ""})).contains(StringUtils.trimToEmpty((String)this.getReturnCode()).toUpperCase()) && successStrings.contains(StringUtils.trimToEmpty((String)this.getResultCode()).toUpperCase()))) {
            StringBuilder errorMsg = new StringBuilder();
            if (this.getReturnCode() != null) {
                errorMsg.append("\u8fd4\u56de\u4ee3\u7801\uff1a").append(this.getReturnCode());
            }
            if (this.getReturnMsg() != null) {
                errorMsg.append("\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a").append(this.getReturnMsg());
            }
            if (this.getResultCode() != null) {
                errorMsg.append("\uff0c\u7ed3\u679c\u4ee3\u7801\uff1a").append(this.getResultCode());
            }
            if (this.getErrCode() != null) {
                errorMsg.append("\uff0c\u9519\u8bef\u4ee3\u7801\uff1a").append(this.getErrCode());
            }
            if (this.getErrCodeDes() != null) {
                errorMsg.append("\uff0c\u9519\u8bef\u8be6\u60c5\uff1a").append(this.getErrCodeDes());
            }
            if (this.getContractErrCode() != null) {
                errorMsg.append(",\u9884\u7b7e\u7ea6\u9519\u8bef\u4ee3\u7801\uff1a").append(this.getContractErrCode());
            }
            if (this.getContractErrCodeDes() != null) {
                errorMsg.append(",\u9884\u7b7e\u7ea6\u9519\u8bef\u63cf\u8ff0:").append(this.getContractErrCodeDes());
            }
            if (this.getContractResultCode() != null) {
                errorMsg.append(",\u9884\u7b7e\u7ea6\u7ed3\u679c\uff1a").append(this.getContractResultCode());
            }
            this.getLogger().warn("\n\u7ed3\u679c\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{},\n{}", map, (Object)errorMsg.toString());
            throw WxPayException.from(this);
        }
    }

    @Override
    public String toString() {
        return WxGsonBuilder.create().toJson((Object)this);
    }

    public String getContractResultCode() {
        return this.contractResultCode;
    }

    public String getContractErrCode() {
        return this.contractErrCode;
    }

    public String getContractErrCodeDes() {
        return this.contractErrCodeDes;
    }

    public String getPrepayId() {
        return this.prepayId;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public String getCodeUrl() {
        return this.codeUrl;
    }

    public Integer getPlanId() {
        return this.planId;
    }

    public Integer getRequestSerial() {
        return this.requestSerial;
    }

    public String getContractCode() {
        return this.contractCode;
    }

    public String getContractDisplayAccount() {
        return this.contractDisplayAccount;
    }

    public String getMwebUrl() {
        return this.mwebUrl;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setContractResultCode(String contractResultCode) {
        this.contractResultCode = contractResultCode;
    }

    public void setContractErrCode(String contractErrCode) {
        this.contractErrCode = contractErrCode;
    }

    public void setContractErrCodeDes(String contractErrCodeDes) {
        this.contractErrCodeDes = contractErrCodeDes;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public void setPlanId(Integer planId) {
        this.planId = planId;
    }

    public void setRequestSerial(Integer requestSerial) {
        this.requestSerial = requestSerial;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public void setContractDisplayAccount(String contractDisplayAccount) {
        this.contractDisplayAccount = contractDisplayAccount;
    }

    public void setMwebUrl(String mwebUrl) {
        this.mwebUrl = mwebUrl;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayEntrustResult)) {
            return false;
        }
        WxPayEntrustResult other = (WxPayEntrustResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contractResultCode = this.getContractResultCode();
        String other$contractResultCode = other.getContractResultCode();
        if (this$contractResultCode == null ? other$contractResultCode != null : !this$contractResultCode.equals(other$contractResultCode)) {
            return false;
        }
        String this$contractErrCode = this.getContractErrCode();
        String other$contractErrCode = other.getContractErrCode();
        if (this$contractErrCode == null ? other$contractErrCode != null : !this$contractErrCode.equals(other$contractErrCode)) {
            return false;
        }
        String this$contractErrCodeDes = this.getContractErrCodeDes();
        String other$contractErrCodeDes = other.getContractErrCodeDes();
        if (this$contractErrCodeDes == null ? other$contractErrCodeDes != null : !this$contractErrCodeDes.equals(other$contractErrCodeDes)) {
            return false;
        }
        String this$prepayId = this.getPrepayId();
        String other$prepayId = other.getPrepayId();
        if (this$prepayId == null ? other$prepayId != null : !this$prepayId.equals(other$prepayId)) {
            return false;
        }
        String this$tradeType = this.getTradeType();
        String other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
            return false;
        }
        String this$codeUrl = this.getCodeUrl();
        String other$codeUrl = other.getCodeUrl();
        if (this$codeUrl == null ? other$codeUrl != null : !this$codeUrl.equals(other$codeUrl)) {
            return false;
        }
        Integer this$planId = this.getPlanId();
        Integer other$planId = other.getPlanId();
        if (this$planId == null ? other$planId != null : !((Object)this$planId).equals(other$planId)) {
            return false;
        }
        Integer this$requestSerial = this.getRequestSerial();
        Integer other$requestSerial = other.getRequestSerial();
        if (this$requestSerial == null ? other$requestSerial != null : !((Object)this$requestSerial).equals(other$requestSerial)) {
            return false;
        }
        String this$contractCode = this.getContractCode();
        String other$contractCode = other.getContractCode();
        if (this$contractCode == null ? other$contractCode != null : !this$contractCode.equals(other$contractCode)) {
            return false;
        }
        String this$contractDisplayAccount = this.getContractDisplayAccount();
        String other$contractDisplayAccount = other.getContractDisplayAccount();
        if (this$contractDisplayAccount == null ? other$contractDisplayAccount != null : !this$contractDisplayAccount.equals(other$contractDisplayAccount)) {
            return false;
        }
        String this$mwebUrl = this.getMwebUrl();
        String other$mwebUrl = other.getMwebUrl();
        if (this$mwebUrl == null ? other$mwebUrl != null : !this$mwebUrl.equals(other$mwebUrl)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        return !(this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayEntrustResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contractResultCode = this.getContractResultCode();
        result = result * 59 + ($contractResultCode == null ? 43 : $contractResultCode.hashCode());
        String $contractErrCode = this.getContractErrCode();
        result = result * 59 + ($contractErrCode == null ? 43 : $contractErrCode.hashCode());
        String $contractErrCodeDes = this.getContractErrCodeDes();
        result = result * 59 + ($contractErrCodeDes == null ? 43 : $contractErrCodeDes.hashCode());
        String $prepayId = this.getPrepayId();
        result = result * 59 + ($prepayId == null ? 43 : $prepayId.hashCode());
        String $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
        String $codeUrl = this.getCodeUrl();
        result = result * 59 + ($codeUrl == null ? 43 : $codeUrl.hashCode());
        Integer $planId = this.getPlanId();
        result = result * 59 + ($planId == null ? 43 : ((Object)$planId).hashCode());
        Integer $requestSerial = this.getRequestSerial();
        result = result * 59 + ($requestSerial == null ? 43 : ((Object)$requestSerial).hashCode());
        String $contractCode = this.getContractCode();
        result = result * 59 + ($contractCode == null ? 43 : $contractCode.hashCode());
        String $contractDisplayAccount = this.getContractDisplayAccount();
        result = result * 59 + ($contractDisplayAccount == null ? 43 : $contractDisplayAccount.hashCode());
        String $mwebUrl = this.getMwebUrl();
        result = result * 59 + ($mwebUrl == null ? 43 : $mwebUrl.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        return result;
    }

    public WxPayEntrustResult(String contractResultCode, String contractErrCode, String contractErrCodeDes, String prepayId, String tradeType, String codeUrl, Integer planId, Integer requestSerial, String contractCode, String contractDisplayAccount, String mwebUrl, String outTradeNo) {
        this.contractResultCode = contractResultCode;
        this.contractErrCode = contractErrCode;
        this.contractErrCodeDes = contractErrCodeDes;
        this.prepayId = prepayId;
        this.tradeType = tradeType;
        this.codeUrl = codeUrl;
        this.planId = planId;
        this.requestSerial = requestSerial;
        this.contractCode = contractCode;
        this.contractDisplayAccount = contractDisplayAccount;
        this.mwebUrl = mwebUrl;
        this.outTradeNo = outTradeNo;
    }

    public WxPayEntrustResult() {
    }
}

