/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RO_llen;
import com.github.fppt.jedismock.operations.RO_pop;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.server.SliceParser;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class RO_bpop
extends AbstractRedisOperation {
    private Slice source;

    RO_bpop(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    abstract RO_pop popper(List<Slice> var1);

    @Override
    void doOptionalWork() {
        this.source = null;
        int size = this.params().size();
        if (size < 2) {
            throw new IndexOutOfBoundsException("require at least 2 params");
        }
        List<Slice> keys = this.params().subList(0, size - 1);
        long timeout = Utils.convertToLong(this.params().get(size - 1).toString());
        for (long currentSleep = 0L; this.source == null && currentSleep < timeout * 1000L; currentSleep += 100L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.source = this.getKey(keys);
        }
    }

    @Override
    Slice response() {
        if (this.source != null) {
            Slice result = this.popper(Collections.singletonList(this.source)).execute();
            return Response.array(Arrays.asList(Response.bulkString(this.source), result));
        }
        return Response.NULL;
    }

    private Slice getKey(List<Slice> list) {
        for (Slice key : list) {
            Slice result = new RO_llen(this.base(), Collections.singletonList(key)).execute();
            int length = SliceParser.consumeInteger(result.data());
            if (length <= 0) continue;
            return key;
        }
        return null;
    }
}

