/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapdb;

import java.io.Serializable;
import java.util.Map;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.ForwardingCloseableIterator;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.mapdb.MapDbQueryEngine;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;

public class MapDbKeyValueAdapter
extends AbstractKeyValueAdapter {
    private DB mapDb;

    public MapDbKeyValueAdapter() {
        this(DBMaker.memoryDB().closeOnJvmShutdown().make());
    }

    public MapDbKeyValueAdapter(DB mapDb) {
        super((QueryEngine)new MapDbQueryEngine());
        Assert.notNull((Object)mapDb, (String)"hzInstance must not be 'null'.");
        this.mapDb = mapDb;
    }

    public Object put(Serializable id, Object item, Serializable keyspace) {
        return this.getMap(keyspace).put((Object)id, item);
    }

    public boolean contains(Serializable id, Serializable keyspace) {
        return this.getMap(keyspace).containsKey((Object)id);
    }

    public Object get(Serializable id, Serializable keyspace) {
        return this.getMap(keyspace).get((Object)id);
    }

    public Object delete(Serializable id, Serializable keyspace) {
        return this.getMap(keyspace).remove((Object)id);
    }

    public Iterable<?> getAllOf(Serializable keyspace) {
        return this.getMap(keyspace).getEntries();
    }

    public CloseableIterator<Map.Entry<Serializable, Object>> entries(Serializable keyspace) {
        return new ForwardingCloseableIterator(this.getMap(keyspace).entryIterator());
    }

    public void deleteAllOf(Serializable keyspace) {
        this.getMap(keyspace).clear();
    }

    public void clear() {
        this.mapDb.close();
    }

    public long count(Serializable keyspace) {
        return this.getMap(keyspace).size();
    }

    public BTreeMap getMap(Serializable keyspace) {
        Assert.isInstanceOf(String.class, (Object)keyspace, (String)"Keyspace identifier must be of type String.");
        return this.mapDb.treeMap((String)((Object)keyspace)).counterEnable().createOrOpen();
    }

    public void destroy() throws Exception {
        this.mapDb.close();
    }
}

