/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapdb.query.predicates;

import java.util.function.Predicate;
import java.util.regex.Pattern;

public class LikePredicate
implements Predicate<Object> {
    private final String expression;

    public LikePredicate(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean test(Object input) {
        if (input == null) {
            return this.expression == null;
        }
        if (!String.class.isInstance(input)) {
            return false;
        }
        String regex = Pattern.quote(this.expression).replaceAll("(?<!\\\\)[%]", "\\\\E.*\\\\Q").replaceAll("(?<!\\\\)[_]", "\\\\E.\\\\Q").replaceAll("\\\\%", "%").replaceAll("\\\\_", "_");
        return Pattern.compile(regex, this.getFlags()).matcher((String)input).matches();
    }

    protected int getFlags() {
        return 0;
    }
}

