/*
 * Decompiled with CFR 0.152.
 */
package com.github.strengthened.prometheus.healthchecks;

import com.github.strengthened.prometheus.healthchecks.Async;
import com.github.strengthened.prometheus.healthchecks.HealthCheck;
import com.github.strengthened.prometheus.healthchecks.HealthStatus;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

final class AsyncHealthCheckDecorator
extends HealthCheck
implements Runnable {
    private final HealthCheck healthCheck;
    private final ScheduledFuture<?> future;
    private volatile HealthStatus result;

    AsyncHealthCheckDecorator(HealthCheck healthCheck, ScheduledExecutorService executorService) {
        AsyncHealthCheckDecorator.check(healthCheck != null, "healthCheck cannot be null");
        AsyncHealthCheckDecorator.check(executorService != null, "executorService cannot be null");
        Async async = healthCheck.getClass().getAnnotation(Async.class);
        AsyncHealthCheckDecorator.check(async != null, "healthCheck must contain Async annotation");
        AsyncHealthCheckDecorator.check(async.period() > 0L, "period cannot be less than or equal to zero");
        AsyncHealthCheckDecorator.check(async.initialDelay() >= 0L, "initialDelay cannot be less than zero");
        this.healthCheck = healthCheck;
        this.result = async.initialState();
        this.future = Async.ScheduleType.FIXED_RATE.equals((Object)async.scheduleType()) ? executorService.scheduleAtFixedRate(this, async.initialDelay(), async.period(), async.unit()) : executorService.scheduleWithFixedDelay(this, async.initialDelay(), async.period(), async.unit());
    }

    @Override
    public void run() {
        this.result = this.healthCheck.execute();
    }

    @Override
    public HealthStatus check() throws Exception {
        return this.result;
    }

    boolean tearDown() {
        return this.future.cancel(true);
    }

    HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    private static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

