/*
 * Decompiled with CFR 0.152.
 */
package com.github.strengthened.prometheus.healthchecks;

import com.github.strengthened.prometheus.healthchecks.Async;
import com.github.strengthened.prometheus.healthchecks.AsyncHealthCheckDecorator;
import com.github.strengthened.prometheus.healthchecks.HealthCheck;
import com.github.strengthened.prometheus.healthchecks.HealthStatus;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HealthChecksCollector
extends Collector {
    final String gaugeMetricHelp;
    final String gaugeMetricName;
    final List<String> labelNames;
    private final ConcurrentMap<String, HealthCheck> healthChecks;
    private final ScheduledExecutorService asyncExecutorService;
    private final Object lock;

    private HealthChecksCollector(String gaugeMetricHelp, String gaugeMetricName, String labelName, ScheduledExecutorService asyncExecutorService) {
        this.gaugeMetricHelp = gaugeMetricHelp;
        this.gaugeMetricName = gaugeMetricName;
        this.asyncExecutorService = asyncExecutorService;
        this.healthChecks = new ConcurrentHashMap<String, HealthCheck>();
        this.labelNames = Collections.singletonList(labelName);
        this.lock = new Object();
    }

    public static HealthChecksCollector newInstance(ScheduledExecutorService asyncExecutorService) {
        return Builder.of().setAsyncExecutorService(asyncExecutorService).build();
    }

    public static HealthChecksCollector newInstance(int asyncExecutorPoolSize) {
        return Builder.of().setAsyncExecutorPoolSize(asyncExecutorPoolSize).build();
    }

    public static HealthChecksCollector newInstance() {
        return Builder.of().build();
    }

    public List<Collector.MetricFamilySamples> collect() {
        if (this.healthChecks.isEmpty()) {
            return Collections.emptyList();
        }
        GaugeMetricFamily checks = new GaugeMetricFamily(this.gaugeMetricName, this.gaugeMetricHelp, this.labelNames);
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            String name = (String)entry.getKey();
            HealthCheck healthCheck = (HealthCheck)entry.getValue();
            HealthStatus result = healthCheck.execute();
            checks.addMetric(Collections.singletonList(name), result.value);
        }
        return Collections.singletonList(checks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthChecksCollector addHealthCheck(String name, HealthCheck healthCheck) {
        Object object = this.lock;
        synchronized (object) {
            if (this.healthChecks.containsKey(HealthChecksCollector.requireNonNull(name, "name null"))) {
                throw new IllegalArgumentException("A health check named " + name + " already exists");
            }
            HealthCheck linked = HealthChecksCollector.requireNonNull(healthCheck, "healthCheck null");
            if (healthCheck.getClass().isAnnotationPresent(Async.class)) {
                linked = new AsyncHealthCheckDecorator(healthCheck, this.asyncExecutorService);
            }
            this.healthChecks.put(name, linked);
        }
        return this;
    }

    public <T extends HealthCheck> HealthChecksCollector addHealthChecks(Map<String, T> healthChecks) {
        for (Map.Entry<String, T> healthCheck : HealthChecksCollector.requireNonNull(healthChecks, "healthChecks null").entrySet()) {
            this.addHealthCheck(healthCheck.getKey(), (HealthCheck)healthCheck.getValue());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthChecksCollector removeHealthCheck(String name) {
        Object object = this.lock;
        synchronized (object) {
            HealthCheck healthCheck = (HealthCheck)this.healthChecks.remove(name);
            if (healthCheck instanceof AsyncHealthCheckDecorator) {
                ((AsyncHealthCheckDecorator)healthCheck).tearDown();
            }
        }
        return this;
    }

    public HealthChecksCollector clear() {
        for (String key : this.healthChecks.keySet()) {
            this.removeHealthCheck(key);
        }
        this.shutdown();
        return this;
    }

    public SortedSet<String> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.healthChecks.keySet()));
    }

    public HealthCheck getHealthCheck(String name) {
        return (HealthCheck)this.healthChecks.get(HealthChecksCollector.requireNonNull(name, "name null"));
    }

    public HealthStatus runHealthCheck(String name) {
        HealthCheck healthCheck = (HealthCheck)this.healthChecks.get(name);
        if (healthCheck == null) {
            throw new NoSuchElementException("No health check named " + name + " exists");
        }
        return healthCheck.execute();
    }

    public HealthChecksCollector shutdown() {
        this.asyncExecutorService.shutdown();
        try {
            if (!this.asyncExecutorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.asyncExecutorService.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.asyncExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
        return this;
    }

    private static <T> T requireNonNull(T obj, String string) {
        if (obj == null) {
            throw new NullPointerException(string);
        }
        return obj;
    }

    public static final class Builder {
        private static final int ASYNC_EXECUTOR_POOL_SIZE = 2;
        private String gaugeMetricHelp = "Health check status results";
        private String gaugeMetricName = "health_check_status";
        private String gaugeMetricLabelName = "system";
        private ScheduledExecutorService asyncExecutorService = Builder.createExecutorService(2);

        public static Builder of() {
            return new Builder();
        }

        public Builder from(HealthChecksCollector instance) {
            HealthChecksCollector.requireNonNull((Object)instance, "instance");
            this.setGaugeMetricHelp(instance.gaugeMetricHelp);
            this.setGaugeMetricName(instance.gaugeMetricName);
            this.setGaugeMetricLabelName(instance.labelNames.get(0));
            this.setAsyncExecutorService(instance.asyncExecutorService);
            return this;
        }

        public HealthChecksCollector build() {
            return new HealthChecksCollector(this.gaugeMetricHelp, this.gaugeMetricName, this.gaugeMetricLabelName, this.asyncExecutorService);
        }

        public Builder setGaugeMetricHelp(String gaugeMetricHelp) {
            this.gaugeMetricHelp = (String)HealthChecksCollector.requireNonNull(gaugeMetricHelp, "gaugeMetricHelp null");
            return this;
        }

        public Builder setGaugeMetricName(String gaugeMetricName) {
            this.gaugeMetricName = (String)HealthChecksCollector.requireNonNull(gaugeMetricName, "gaugeMetricName null");
            return this;
        }

        public Builder setGaugeMetricLabelName(String gaugeMetricLabelName) {
            this.gaugeMetricLabelName = (String)HealthChecksCollector.requireNonNull(gaugeMetricLabelName, "gaugeMetricLabelName null");
            return this;
        }

        public Builder setAsyncExecutorPoolSize(int asyncExecutorPoolSize) {
            this.asyncExecutorService = Builder.createExecutorService(asyncExecutorPoolSize);
            return this;
        }

        public Builder setAsyncExecutorService(ScheduledExecutorService asyncExecutorService) {
            this.asyncExecutorService = (ScheduledExecutorService)HealthChecksCollector.requireNonNull(asyncExecutorService, "asyncExecutorService null");
            return this;
        }

        private static ScheduledExecutorService createExecutorService(int corePoolSize) {
            ScheduledExecutorService asyncExecutorService = Executors.newScheduledThreadPool(corePoolSize, Executors.defaultThreadFactory());
            try {
                Method method = asyncExecutorService.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
                method.invoke((Object)asyncExecutorService, true);
            }
            catch (NoSuchMethodException ex) {
                Builder.logSetExecutorCancellationPolicyFailure(ex);
            }
            catch (IllegalAccessException ex) {
                Builder.logSetExecutorCancellationPolicyFailure(ex);
            }
            catch (InvocationTargetException ex) {
                Builder.logSetExecutorCancellationPolicyFailure(ex);
            }
            return asyncExecutorService;
        }

        private static void logSetExecutorCancellationPolicyFailure(Exception ex) {
            System.err.println(String.format("Tried but failed to set executor cancellation policy to remove on cancel which has been introduced in Java 7. This could result in a memory leak if many asynchronous health checks are registered and removed because cancellation does not actually remove them from the executor. %s", ex.getMessage()));
        }
    }
}

