/*
 * Decompiled with CFR 0.152.
 */
package at.pollux.thymeleaf.shiro.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.StandardExpressionParser;
import org.thymeleaf.util.EvaluationUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class ThymeleafFacade {
    private ThymeleafFacade() {
        throw new UnsupportedOperationException();
    }

    public static String getRawValue(IProcessableElementTag element, AttributeName attributeName) {
        Validate.notNull((Object)element, (String)"element must not be null");
        Validate.notNull((Object)attributeName, (String)"attributeName must not be empty");
        String rawValue = StringUtils.trim((Object)element.getAttributeValue(attributeName));
        Validate.notEmpty((String)rawValue, (String)("value of '" + attributeName + "' must not be empty"));
        return rawValue;
    }

    public static String getRawValue(IProcessableElementTag element, String attributeName) {
        Validate.notNull((Object)element, (String)"element must not be null");
        Validate.notEmpty((String)attributeName, (String)"attributeName must not be empty");
        String rawValue = StringUtils.trim((Object)element.getAttributeValue(attributeName));
        Validate.notEmpty((String)rawValue, (String)("value of '" + attributeName + "' must not be empty"));
        return rawValue;
    }

    public static Object evaluateExpression(ITemplateContext arguments, String expression) throws TemplateProcessingException {
        Validate.notNull((Object)arguments, (String)"arguments must not be null");
        Validate.notEmpty((String)expression, (String)"expression must not be empty");
        StandardExpressionParser parser = new StandardExpressionParser();
        IStandardExpression evaluableExpression = parser.parseExpression((IExpressionContext)arguments, expression);
        return evaluableExpression.execute((IExpressionContext)arguments);
    }

    public static List<Object> evaluateAsIterable(ITemplateContext arguments, String rawValue) throws TemplateProcessingException {
        Validate.notNull((Object)arguments, (String)"arguments must not be null");
        Validate.notEmpty((String)rawValue, (String)"rawValue must not be empty");
        Object evaluatedExpression = ThymeleafFacade.evaluateExpression(arguments, rawValue);
        return EvaluationUtils.evaluateAsList((Object)evaluatedExpression);
    }

    public static List<Object> evaluateAsIterableOrRawValue(ITemplateContext arguments, String rawValue) {
        Validate.notNull((Object)arguments, (String)"arguments must not be null");
        Validate.notEmpty((String)rawValue, (String)"rawValue must not be empty");
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            result.addAll(ThymeleafFacade.evaluateAsIterable(arguments, rawValue));
        }
        catch (TemplateProcessingException ex) {
            result.add(rawValue);
        }
        return Collections.unmodifiableList(result);
    }

    public static List<String> evaluateAsStringsWithDelimiter(ITemplateContext arguments, String rawValue, String delimiter) {
        Validate.notNull((Object)arguments, (String)"arguments must not be null");
        Validate.notEmpty((String)rawValue, (String)"rawValue must not be empty");
        Validate.notEmpty((String)delimiter, (String)"delimiter must not be empty");
        ArrayList<String> result = new ArrayList<String>();
        List<Object> iterates = ThymeleafFacade.evaluateAsIterableOrRawValue(arguments, rawValue);
        for (Object o : iterates) {
            result.addAll(Arrays.asList(StringUtils.split((Object)o, (String)delimiter)));
        }
        return Collections.unmodifiableList(result);
    }
}

