/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.salt.SaltGenerator;

public class SimplePBEByteEncryptor
implements PBEByteEncryptor {
    private String password = null;
    private SaltGenerator saltGenerator = null;
    private int iterations;
    private String algorithm = null;

    public byte[] encrypt(byte[] message) {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.algorithm);
        byte[] salt = this.saltGenerator.generateSalt(8);
        PBEKeySpec keySpec = new PBEKeySpec(this.password.toCharArray(), salt, this.iterations);
        SecretKey key = factory.generateSecret(keySpec);
        Cipher cipherEncrypt = Cipher.getInstance(this.algorithm);
        cipherEncrypt.init(1, key);
        byte[] params = cipherEncrypt.getParameters().getEncoded();
        byte[] encryptedMessage = cipherEncrypt.doFinal(message);
        return ByteBuffer.allocate(1 + params.length + encryptedMessage.length).put((byte)params.length).put(params).put(encryptedMessage).array();
    }

    public byte[] decrypt(byte[] encryptedMessage) {
        int paramsLength = Byte.toUnsignedInt(encryptedMessage[0]);
        int messageLength = encryptedMessage.length - paramsLength - 1;
        byte[] params = new byte[paramsLength];
        byte[] message = new byte[messageLength];
        System.arraycopy(encryptedMessage, 1, params, 0, paramsLength);
        System.arraycopy(encryptedMessage, paramsLength + 1, message, 0, messageLength);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.algorithm);
        PBEKeySpec keySpec = new PBEKeySpec(this.password.toCharArray());
        SecretKey key = factory.generateSecret(keySpec);
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.algorithm);
        algorithmParameters.init(params);
        Cipher cipherDecrypt = Cipher.getInstance(this.algorithm);
        cipherDecrypt.init(2, (Key)key, algorithmParameters);
        return cipherDecrypt.doFinal(message);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

