/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.caching;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

@Order(value=-2147483648)
public class RefreshScopeRefreshedEventListener
implements ApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(RefreshScopeRefreshedEventListener.class);
    public static final String REFRESHED_EVENT_CLASS = "org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent";
    public static final String ENVIRONMENT_EVENT_CLASS = "org.springframework.cloud.context.environment.EnvironmentChangeEvent";
    private final ConfigurableEnvironment environment;
    private final EncryptablePropertySourceConverter converter;

    public RefreshScopeRefreshedEventListener(ConfigurableEnvironment environment, EncryptablePropertySourceConverter converter) {
        this.environment = environment;
        this.converter = converter;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.isAssignable(ENVIRONMENT_EVENT_CLASS, event) || this.isAssignable(REFRESHED_EVENT_CLASS, event)) {
            log.info("Refreshing cached encryptable property sources");
            this.refreshCachedProperties();
            this.decorateNewSources();
        }
    }

    private void decorateNewSources() {
        MutablePropertySources propSources = this.environment.getPropertySources();
        this.converter.convertPropertySources(propSources);
    }

    boolean isAssignable(String className, Object value) {
        try {
            return ClassUtils.isAssignableValue((Class)ClassUtils.forName((String)className, null), (Object)value);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void refreshCachedProperties() {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        propertySources.forEach(this::refreshPropertySource);
    }

    private void refreshPropertySource(PropertySource<?> propertySource) {
        if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource cps = (CompositePropertySource)propertySource;
            cps.getPropertySources().forEach(this::refreshPropertySource);
        } else if (propertySource instanceof EncryptablePropertySource) {
            EncryptablePropertySource eps = (EncryptablePropertySource)propertySource;
            eps.refresh();
        }
    }
}

